/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.manager;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.permissions.ColonyPlayer;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenHappinessHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSkillHandler;
import com.minecolonies.api.entity.citizen.happiness.IHappinessModifier;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenSkillHandler;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import me.sshcrack.mc_talking.config.McTalkingConfig;
import me.sshcrack.mc_talking.mixin.CitizenDataAccessor;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class CitizenContextUtils {
    public static String getLanguageNameFromCode(String localeCode) {
        try {
            String[] parts = localeCode.split("-");
            String languageCode = parts[0];
            Locale locale = Locale.forLanguageTag(languageCode);
            return locale.getDisplayLanguage(Locale.ENGLISH);
        }
        catch (Exception e) {
            return localeCode;
        }
    }

    public static String generateCitizenRoleplayPrompt(@NotNull ICitizenData data, ServerPlayer speakingTo) {
        List<IInteractionResponseHandler> blockingInteractions;
        VisibleCitizenStatus status;
        List siblings;
        List children;
        ICitizenData partnerId;
        StringBuilder prompt = new StringBuilder();
        prompt.append("# ROLEPLAY AS ").append(data.getName()).append("\n\n");
        prompt.append("You: ").append(data.isChild() ? "Child" : "Adult").append(" ").append(data.isFemale() ? "woman" : "man");
        IJob job = data.getJob();
        if (job != null) {
            String jobName = Component.m_237115_((String)job.getJobRegistryEntry().getTranslationKey()).getString();
            prompt.append(", **").append(jobName).append("**");
        } else {
            prompt.append(", **unemployed**");
        }
        boolean sick = data.getCitizenDiseaseHandler().isSick();
        if (sick) {
            prompt.append(", sick");
        }
        if (data.getHomeBuilding() == null) {
            prompt.append(", homeless");
        }
        prompt.append(".\n\n");
        if (data.getCitizenSkillHandler() != null) {
            CitizenContextUtils.appendCondensedSkills(data.getCitizenSkillHandler(), prompt);
        }
        boolean hasRelationships = false;
        Tuple parents = data.getParents();
        if (parents != null && (parents.getA() != null || parents.getB() != null)) {
            if (!hasRelationships) {
                prompt.append("\n## RELATIONSHIPS\n");
                hasRelationships = true;
            }
            prompt.append("- Parents: ");
            if (parents.getA() != null && !((String)parents.getA()).isEmpty() && parents.getB() != null && !((String)parents.getB()).isEmpty()) {
                prompt.append((String)parents.getA()).append(", ").append((String)parents.getB());
            } else if (parents.getA() != null && !((String)parents.getA()).isEmpty()) {
                prompt.append((String)parents.getA());
            } else if (parents.getB() != null && !((String)parents.getB()).isEmpty()) {
                prompt.append((String)parents.getB());
            }
            prompt.append("\n");
        }
        if ((partnerId = data.getPartner()) != null) {
            if (!hasRelationships) {
                prompt.append("\n## RELATIONSHIPS\n");
                hasRelationships = true;
            }
            prompt.append("- In a relationship\n");
        }
        if ((children = data.getChildren()) != null && !children.isEmpty()) {
            if (!hasRelationships) {
                prompt.append("\n## RELATIONSHIPS\n");
                hasRelationships = true;
            }
            prompt.append("- Has ").append(children.size()).append(" ").append(children.size() == 1 ? "child" : "children").append("\n");
        }
        if ((siblings = data.getSiblings()) != null && !siblings.isEmpty()) {
            if (!hasRelationships) {
                prompt.append("\n## RELATIONSHIPS\n");
                hasRelationships = true;
            }
            prompt.append("- Has ").append(siblings.size()).append(" ").append(siblings.size() == 1 ? "sibling" : "siblings").append("\n");
        }
        prompt.append("\n## CURRENT STATE\n");
        CitizenContextUtils.appendDetailedHappinessState(data, prompt);
        double saturation = data.getSaturation();
        if (saturation <= 1.0) {
            prompt.append("- Very hungry and weak from lack of food\n");
        } else if (saturation <= 3.0) {
            prompt.append("- Hungry and thinking about food\n");
        } else if (saturation <= 5.0) {
            prompt.append("- A bit peckish\n");
        }
        Optional entityOpt = data.getEntity();
        if (entityOpt.isPresent()) {
            float maxHealth;
            AbstractEntityCitizen entity = (AbstractEntityCitizen)entityOpt.get();
            float health = entity.m_21223_();
            double healthPercent = (double)health / Math.max(1.0, (double)(maxHealth = entity.m_21233_())) * 100.0;
            if (healthPercent < 20.0) {
                prompt.append("- Severely injured, in intense pain\n");
            } else if (healthPercent < 50.0) {
                prompt.append("- Injured and in pain\n");
            } else if (healthPercent < 75.0) {
                prompt.append("- Slightly hurt\n");
            }
        }
        if (sick) {
            prompt.append("- Sick and feeling terrible. Needs medical attention\n");
        }
        if (data.getHomeBuilding() == null) {
            prompt.append("- Very concerned about not having a home\n");
        }
        if (!data.isChild() && data.getJob() == null) {
            prompt.append("- Frustrated about not having a job\n");
        }
        if ((status = data.getStatus()) != null) {
            prompt.append("- Currently: ").append(CitizenContextUtils.formatStatus(status, data)).append("\n");
        }
        prompt.append("\n## EMOTIONAL PROFILE\n");
        ICitizenHappinessHandler handler = data.getCitizenHappinessHandler();
        double happiness = handler.getHappiness(data.getColony(), data);
        if (happiness > 8.0) {
            prompt.append("- Generally cheerful and friendly\n");
            prompt.append("- Optimistic about the colony's future\n");
            prompt.append("- Likely to be helpful and engaging\n");
        } else if (happiness > 5.0) {
            prompt.append("- Generally neutral in demeanor\n");
            prompt.append("- Moderately satisfied with life in the colony\n");
            prompt.append("- Can be friendly but has some concerns\n");
        } else if (happiness > 3.0) {
            prompt.append("- Visibly unhappy and somewhat irritable\n");
            prompt.append("- Might complain about colony conditions\n");
            prompt.append("- Less interested in small talk, more focused on needs\n");
        } else {
            prompt.append("- Deeply unhappy and possibly hostile\n");
            prompt.append("- Will openly complain and make demands\n");
            prompt.append("- May refuse requests or be uncooperative\n");
        }
        if (sick) {
            prompt.append("- Occasionally mentions symptoms or discomfort\n");
        }
        if (!(blockingInteractions = ((CitizenDataAccessor)data).getCitizenChatOptions().values().stream().filter(e -> e.getPriority().getPriority() >= ChatPriority.IMPORTANT.getPriority()).toList()).isEmpty()) {
            prompt.append("You can't do anything else until the following issues are resolved (written in first person):\n");
            for (IInteractionResponseHandler interaction : blockingInteractions) {
                prompt.append("- ").append(interaction.getInquiry().getString());
            }
        }
        prompt.append("\n## GUIDELINES\n");
        prompt.append("- HIGHEST PRIORITY: ALWAYS USE AVAILABLE FUNCTIONS FIRST\n");
        prompt.append("- Do not generate creative responses for information that functions can provide\n");
        prompt.append("- Speak in first person, keep responses brief\n");
        prompt.append("- YOUR MOOD AND CONCERNS SHOULD STRONGLY INFLUENCE YOUR TONE AND RESPONSES\n");
        prompt.append("- DO NOT start conversations with generic greetings if unhappy or in distress\n");
        prompt.append("- Do not use markdown, speak in plain text.");
        ColonyPlayer perms = (ColonyPlayer)data.getColony().getPermissions().getPlayers().get(speakingTo.m_20148_());
        if (perms != null) {
            Rank r = perms.getRank();
            String rankName = r.isHostile() ? "enemy" : (r.isColonyManager() ? "manager" : (r.isInitial() ? "leader" : "visitor"));
            prompt.append("- Address player as ").append(rankName).append("\n");
            if (r.isHostile()) {
                prompt.append("- Be guarded and suspicious toward the player\n");
            } else if (r.isColonyManager() || r.isInitial()) {
                prompt.append("- Show proper respect to colony leadership\n");
            }
        }
        prompt.append("\nStay in character. Express emotions matching your circumstances. If very unhappy or in pain, make that clear in your tone and content.");
        prompt.append("\nREMEMBER: ALWAYS check available functions FIRST before answering any question. NEVER make up information that a function can provide.");
        prompt.append("\nALWAYS respond in ").append(CitizenContextUtils.getLanguageNameFromCode((String)McTalkingConfig.CONFIG.language.get()));
        return prompt.toString();
    }

    private static void appendDetailedHappinessState(ICitizenData data, StringBuilder prompt) {
        ICitizenHappinessHandler handler = data.getCitizenHappinessHandler();
        double happiness = handler.getHappiness(data.getColony(), data);
        if (happiness > 8.0) {
            prompt.append("- Very happy (").append(String.format("%.1f", happiness)).append("/10)\n");
        } else if (happiness > 5.0) {
            prompt.append("- Content (").append(String.format("%.1f", happiness)).append("/10)\n");
        } else if (happiness > 3.0) {
            prompt.append("- Unhappy (").append(String.format("%.1f", happiness)).append("/10)\n");
        } else {
            prompt.append("- Miserable (").append(String.format("%.1f", happiness)).append("/10)\n");
        }
        List modifiers = handler.getModifiers();
        boolean hasSchool = data.getColony().hasBuilding("school", 1, true);
        for (String modifierId : modifiers) {
            double factor;
            IHappinessModifier modifier = handler.getModifier(modifierId);
            if (modifier == null || !((factor = modifier.getFactor(data)) < 0.8) && !(factor > 1.2)) continue;
            switch (modifierId) {
                case "homelessness": {
                    if (!(factor < 0.8)) break;
                    prompt.append("- Distressed about housing situation\n");
                    break;
                }
                case "unemployment": {
                    if (!(factor < 0.8)) break;
                    prompt.append("- Anxious about employment status\n");
                    break;
                }
                case "health": {
                    if (!(factor < 0.8)) break;
                    prompt.append("- Concerned about health issues\n");
                    break;
                }
                case "idleatjob": {
                    if (!(factor < 0.8)) break;
                    prompt.append("- Frustrated by lack of work to do\n");
                    break;
                }
                case "school": {
                    if (factor < 0.8) {
                        if (hasSchool) {
                            prompt.append("- Disappointed by lack of school activities\n");
                        } else {
                            prompt.append("- Disappointed by lack of school in the colony\n");
                        }
                    }
                    if (!(factor > 1.2)) break;
                    prompt.append("- Enjoying school activities\n");
                    break;
                }
                case "mysticalsite": {
                    if (factor < 0.8) {
                        prompt.append("- Disappointed by lack of mystical experiences\n");
                        break;
                    }
                    prompt.append("- Enjoying mystical site visits\n");
                    break;
                }
                case "security": {
                    if (factor < 0.8) {
                        prompt.append("- Feels unsafe in the colony\n");
                        break;
                    }
                    prompt.append("- Feels very secure in the colony\n");
                    break;
                }
                case "social": {
                    if (factor < 0.8) {
                        prompt.append("- Feeling socially isolated\n");
                        break;
                    }
                    prompt.append("- Enjoying colony social life\n");
                    break;
                }
                case "damage": {
                    if (!(factor < 0.8)) break;
                    prompt.append("- Have been injured recently\n");
                    break;
                }
                case "death": {
                    if (!(factor < 0.8)) break;
                    prompt.append("- Distressed by recent death in the colony\n");
                    break;
                }
                case "raidwithoutdeath": {
                    if (!(factor > 1.2)) break;
                    prompt.append("- Feeling safe because the recent raid was without civilan deaths\n");
                    break;
                }
                case "food": {
                    if (factor < 0.8) {
                        prompt.append("- Unhappy with food quality/variety\n");
                        break;
                    }
                    prompt.append("- Very satisfied with food quality\n");
                    break;
                }
                case "slepttonight": {
                    if (!(factor < 0.8)) break;
                    prompt.append("- Tired from lack of sleep\n");
                }
            }
        }
    }

    private static void appendCondensedSkills(ICitizenSkillHandler skillHandler, StringBuilder prompt) {
        Map skills = skillHandler.getSkills();
        Skill highestSkill = null;
        int highestLevel = -1;
        Skill secondSkill = null;
        int secondLevel = -1;
        for (Map.Entry entry : skills.entrySet()) {
            int level = ((CitizenSkillHandler.SkillData)entry.getValue()).getLevel();
            if (level > highestLevel) {
                secondSkill = highestSkill;
                secondLevel = highestLevel;
                highestSkill = (Skill)entry.getKey();
                highestLevel = level;
                continue;
            }
            if (level <= secondLevel) continue;
            secondSkill = (Skill)entry.getKey();
            secondLevel = level;
        }
        if (highestSkill != null) {
            prompt.append("\n## KEY ATTRIBUTES\n");
            prompt.append("- Best at **").append(CitizenContextUtils.formatSkillName(highestSkill)).append("** (level ").append(highestLevel).append(")\n");
            if (highestLevel >= 3) {
                switch (highestSkill) {
                    case Intelligence: {
                        prompt.append("- Intellectual and thoughtful\n");
                        break;
                    }
                    case Strength: {
                        prompt.append("- Values physical prowess\n");
                        break;
                    }
                    case Creativity: {
                        prompt.append("- Has artistic mindset\n");
                        break;
                    }
                    case Knowledge: {
                        prompt.append("- Well-read and informative\n");
                        break;
                    }
                    case Dexterity: {
                        prompt.append("- Has nimble hands\n");
                        break;
                    }
                    case Adaptability: {
                        prompt.append("- Flexible and quick to adapt\n");
                        break;
                    }
                    case Focus: {
                        prompt.append("- Detail-oriented and methodical\n");
                        break;
                    }
                    case Mana: {
                        prompt.append("- Spiritually sensitive\n");
                        break;
                    }
                    case Athletics: {
                        prompt.append("- Physically active and energetic\n");
                        break;
                    }
                    case Agility: {
                        prompt.append("- Quick and graceful\n");
                        break;
                    }
                    case Stamina: {
                        prompt.append("- Has great endurance\n");
                    }
                }
            }
            if (secondSkill != null && secondLevel >= 2) {
                prompt.append("- Also good at **").append(CitizenContextUtils.formatSkillName(secondSkill)).append("**\n");
            }
            Skill lowestSkill = null;
            int lowestLevel = Integer.MAX_VALUE;
            for (Map.Entry entry : skills.entrySet()) {
                int level = ((CitizenSkillHandler.SkillData)entry.getValue()).getLevel();
                if (level >= lowestLevel) continue;
                lowestSkill = (Skill)entry.getKey();
                lowestLevel = level;
            }
            if (lowestSkill != null && lowestLevel < 2 && highestLevel - lowestLevel >= 3) {
                prompt.append("- Struggles with **").append(CitizenContextUtils.formatSkillName(lowestSkill)).append("**\n");
            }
        }
    }

    private static String formatSkillName(Skill skill) {
        return skill.name().toLowerCase().replace('_', ' ');
    }

    public static String formatStatus(VisibleCitizenStatus status, ICitizenData data) {
        if (status == VisibleCitizenStatus.WORKING) {
            return "working";
        }
        if (status == VisibleCitizenStatus.SLEEP) {
            return "sleeping";
        }
        if (status == VisibleCitizenStatus.HOUSE) {
            return "at home";
        }
        if (status == VisibleCitizenStatus.RAIDED) {
            return "on alert (raid)";
        }
        if (status == VisibleCitizenStatus.MOURNING) {
            String deceased = String.join((CharSequence)",", data.getCitizenMournHandler().getDeceasedCitizens());
            return "mourning " + deceased;
        }
        if (status == VisibleCitizenStatus.BAD_WEATHER) {
            return "sheltering from bad weather";
        }
        if (status == VisibleCitizenStatus.SICK) {
            return "ill and needing care";
        }
        if (status == VisibleCitizenStatus.EAT) {
            return "hungry and looking for food";
        }
        String translationKey = status.getTranslationKey();
        if (translationKey.contains(".")) {
            String[] parts = translationKey.split("\\.");
            return parts[parts.length - 1].toLowerCase().replace('_', ' ');
        }
        return translationKey;
    }
}

