/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking;

import com.minecolonies.api.entity.citizen.AbstractCivilianEntity;
import me.sshcrack.mc_talking.ConversationManager;
import me.sshcrack.mc_talking.network.AiStatus;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RenderNameTagEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;

@Mod(value="mc_talking", dist={Dist.CLIENT})
public class McTalkingClient {
    public McTalkingClient(ModContainer container) {
        NeoForge.EVENT_BUS.register((Object)this);
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    @SubscribeEvent
    public void onDisconnect(LevelEvent.Unload event) {
        ConversationManager.clearAiStatus();
    }

    @SubscribeEvent
    public void onRenderName(RenderNameTagEvent event) {
        Entity entity = event.getEntity();
        Minecraft minecraft = Minecraft.getInstance();
        if (!(entity instanceof AbstractCivilianEntity)) {
            return;
        }
        AbstractCivilianEntity citizen = (AbstractCivilianEntity)entity;
        assert (minecraft.player != null);
        if (entity.isInvisibleTo((Player)minecraft.player)) {
            return;
        }
        AiStatus status = ConversationManager.getAiStatus(citizen.getUUID());
        if (status == AiStatus.NONE) {
            return;
        }
        MutableComponent text = Component.literal((String)" (").append((Component)Component.translatable((String)("mc_talking.ai_status." + status.name().toLowerCase()))).append((Component)Component.literal((String)")")).withStyle(ChatFormatting.GRAY);
        event.setContent((Component)event.getContent().copy().append((Component)text));
    }
}

