/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.manager;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import de.maxhenkel.voicechat.api.audiochannel.EntityAudioChannel;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import java.util.UUID;
import me.sshcrack.mc_talking.McTalking;
import me.sshcrack.mc_talking.McTalkingVoicechatPlugin;
import me.sshcrack.mc_talking.manager.GeminiWsClient;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class TalkingManager {
    private static final DefaultArtifactVersion FIXED_VERSION = new DefaultArtifactVersion("1.21.1-2.5.31");
    private static final boolean IS_BUG_FIXED_VC = ((ModContainer)ModList.get().getModContainerById("voicechat").get()).getModInfo().getVersion().compareTo((Object)FIXED_VERSION) >= 0;
    GeminiWsClient client;
    EntityAudioChannel channel;
    AbstractEntityCitizen entity;
    OpusDecoder decoder;

    public TalkingManager(AbstractEntityCitizen entity, ServerPlayer initialPlayer) {
        McTalking.LOGGER.info("Creating TalkingManager for entity: {}", (Object)entity.getStringUUID());
        if (McTalkingVoicechatPlugin.vcApi == null) {
            throw new IllegalStateException("Voicechat API is not initialized");
        }
        this.entity = entity;
        UUID uuid = IS_BUG_FIXED_VC ? UUID.randomUUID() : entity.getUUID();
        this.channel = McTalkingVoicechatPlugin.vcApi.createEntityAudioChannel(uuid, McTalkingVoicechatPlugin.vcApi.fromEntity((Object)entity));
        if (this.channel == null) {
            throw new IllegalStateException("Failed to create audio channel for entity: " + entity.getStringUUID());
        }
        this.channel.setWhispering(true);
        this.client = new GeminiWsClient(this, initialPlayer);
        this.decoder = McTalkingVoicechatPlugin.vcApi.createDecoder();
    }

    public void promptAudioRaw(short[] raw) {
        this.client.batchAudio(raw);
    }

    public void promptAudioOpus(byte[] audio) {
        short[] raw = this.decoder.decode(audio);
        this.client.batchAudio(raw);
    }

    public void close() {
        this.client.close();
        this.channel = null;
    }

    public void promptSystemText(String newStatusPrompt) {
    }

    static {
        McTalking.LOGGER.info("Compatibility check for voicechat, is bug fixed: {}", (Object)IS_BUG_FIXED_VC);
    }
}

