/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.util;

public class AudioHelper {
    public static short[] changePitch(short[] inputSamples, int sampleRate, float pitchFactor) {
        if (pitchFactor == 1.0f) {
            return inputSamples;
        }
        return inputSamples;
    }

    private static short[] timeStretch(short[] input, float stretchFactor) {
        int outputLength = (int)((float)input.length * stretchFactor);
        short[] output = new short[outputLength];
        for (int i = 0; i < outputLength; ++i) {
            float sourcePos = (float)i / stretchFactor;
            int index = (int)sourcePos;
            float fraction = sourcePos - (float)index;
            if (index >= input.length - 1) {
                output[i] = input[input.length - 1];
                continue;
            }
            short sample1 = input[index];
            short sample2 = input[index + 1];
            output[i] = (short)((float)sample1 + fraction * (float)(sample2 - sample1));
        }
        return output;
    }

    public static short[] resampleAudio(short[] input, int inputSampleRate, int outputSampleRate) {
        if (inputSampleRate == outputSampleRate) {
            return input;
        }
        double ratio = (double)outputSampleRate / (double)inputSampleRate;
        int outputLength = (int)Math.ceil((double)input.length * ratio);
        short[] output = new short[outputLength];
        for (int i = 0; i < outputLength; ++i) {
            double position = (double)i / ratio;
            int index = (int)position;
            double fraction = position - (double)index;
            if (index >= input.length - 1) {
                output[i] = input[input.length - 1];
                continue;
            }
            short sample1 = input[index];
            short sample2 = input[index + 1];
            output[i] = (short)((double)sample1 + fraction * (double)(sample2 - sample1));
        }
        return output;
    }
}

