/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.ServerPlayer;
import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.events.VoicechatServerStartedEvent;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import me.sshcrack.mc_talking.ConversationManager;
import me.sshcrack.mc_talking.McTalking;
import me.sshcrack.mc_talking.config.McTalkingConfig;
import me.sshcrack.mc_talking.manager.TalkingManager;

@ForgeVoicechatPlugin
public class McTalkingVoicechatPlugin
implements VoicechatPlugin {
    public static VoicechatServerApi vcApi;
    private final Map<UUID, ScheduledFuture<?>> silenceTimeouts = new ConcurrentHashMap();
    private final Map<UUID, Long> lastVoiceActivity = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Long> speechEndDetections = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Integer> consecutiveSilentPackets = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Boolean> isSpeaking = new ConcurrentHashMap<UUID, Boolean>();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private static final long SILENCE_DURATION_MS = 2000L;
    private static final long SILENCE_INTERVAL_MS = 20L;
    private static final long VOICE_INACTIVITY_THRESHOLD_MS = 150L;
    private static final int SPEECH_END_THRESHOLD = 10;
    private static final long PERIODIC_SILENCE_CHECK_MS = 100L;

    public String getPluginId() {
        return "mc_talking";
    }

    public void initialize(VoicechatApi api) {
        McTalking.LOGGER.info("Initializing Voicechat Plugin");
        this.executor.scheduleAtFixedRate(this::checkForSpeechEnd, 100L, 100L, TimeUnit.MILLISECONDS);
    }

    public void onServerStart(VoicechatServerStartedEvent event) {
        McTalking.LOGGER.info("Voicechat Server Started");
        vcApi = event.getVoicechat();
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(MicrophonePacketEvent.class, this::handleMicPacket);
        registration.registerEvent(VoicechatServerStartedEvent.class, this::onServerStart);
    }

    public void handleMicPacket(MicrophonePacketEvent event) {
        VoicechatConnection sender = event.getSenderConnection();
        if (sender == null) {
            return;
        }
        MicrophonePacket packet = (MicrophonePacket)event.getPacket();
        if (packet.isWhispering()) {
            return;
        }
        if (sender.isDisabled()) {
            return;
        }
        ServerPlayer vcPlayer = sender.getPlayer();
        if (sender.isInGroup() && !((Boolean)McTalkingConfig.CONFIG.respondInGroups.get()).booleanValue()) {
            return;
        }
        net.minecraft.server.level.ServerPlayer player = (net.minecraft.server.level.ServerPlayer)vcPlayer.getPlayer();
        AbstractEntityCitizen entity = ConversationManager.getActiveEntity(player.getUUID());
        if (entity == null) {
            return;
        }
        TalkingManager manager = ConversationManager.getClientForEntity(entity.getUUID());
        if (manager == null) {
            return;
        }
        UUID entityId = entity.getUUID();
        byte[] opusData = packet.getOpusEncodedData();
        boolean hasVoiceActivity = this.hasVoiceActivity(opusData);
        long currentTime = System.currentTimeMillis();
        manager.promptAudioOpus(opusData);
        if (hasVoiceActivity) {
            this.consecutiveSilentPackets.put(entityId, 0);
            this.isSpeaking.put(entityId, true);
            this.lastVoiceActivity.put(entityId, currentTime);
            this.cancelSilenceTask(entityId);
        } else {
            int silentCount = this.consecutiveSilentPackets.getOrDefault(entityId, 0) + 1;
            this.consecutiveSilentPackets.put(entityId, silentCount);
            if (silentCount >= 10 && this.isSpeaking.getOrDefault(entityId, false).booleanValue()) {
                this.speechEndDetections.put(entityId, currentTime);
            }
        }
    }

    private boolean hasVoiceActivity(byte[] opusData) {
        if (opusData == null || opusData.length <= 1) {
            return false;
        }
        int minimumVoicePacketSize = 10;
        return opusData.length > minimumVoicePacketSize;
    }

    private void scheduleSilenceTask(UUID entityId, TalkingManager manager) {
        if (this.silenceTimeouts.containsKey(entityId)) {
            return;
        }
        McTalking.LOGGER.info("Scheduling silence packets for entity {}", (Object)entityId);
        ScheduledFuture<?> future = this.executor.scheduleAtFixedRate(() -> {
            short[] ambientAudio = this.generateAmbientNoise(960);
            manager.promptAudioRaw(ambientAudio);
        }, 0L, 20L, TimeUnit.MILLISECONDS);
        this.executor.schedule(() -> {
            McTalking.LOGGER.info("Stopping silence packets for entity {}", (Object)entityId);
            this.cancelSilenceTask(entityId);
            this.lastVoiceActivity.remove(entityId);
            this.speechEndDetections.remove(entityId);
            this.consecutiveSilentPackets.remove(entityId);
        }, 2000L, TimeUnit.MILLISECONDS);
        this.silenceTimeouts.put(entityId, future);
    }

    private short[] generateAmbientNoise(int length) {
        short[] audio = new short[length];
        Random random = new Random();
        double baseAmplitude = 5.0;
        for (int i = 0; i < length; ++i) {
            double noise = random.nextGaussian() * baseAmplitude;
            audio[i] = (short)noise;
        }
        return audio;
    }

    private void cancelSilenceTask(UUID entityId) {
        ScheduledFuture<?> future = this.silenceTimeouts.remove(entityId);
        if (future != null) {
            future.cancel(true);
        }
    }

    private void checkForSpeechEnd() {
        TalkingManager manager;
        UUID entityId;
        long currentTime = System.currentTimeMillis();
        for (Map.Entry<UUID, Long> entry : new HashMap<UUID, Long>(this.speechEndDetections).entrySet()) {
            entityId = entry.getKey();
            Long speechEndTime = entry.getValue();
            if (speechEndTime == null || currentTime - speechEndTime < 150L || !this.isSpeaking.getOrDefault(entityId, false).booleanValue() || this.silenceTimeouts.containsKey(entityId)) continue;
            this.isSpeaking.put(entityId, false);
            this.speechEndDetections.remove(entityId);
            manager = ConversationManager.getClientForEntity(entityId);
            if (manager == null) continue;
            this.scheduleSilenceTask(entityId, manager);
        }
        for (Map.Entry<UUID, Long> entry : new HashMap<UUID, Long>(this.lastVoiceActivity).entrySet()) {
            entityId = entry.getKey();
            Long lastActivity = entry.getValue();
            if (this.speechEndDetections.containsKey(entityId) || this.silenceTimeouts.containsKey(entityId) || !this.isSpeaking.getOrDefault(entityId, false).booleanValue() || lastActivity == null || currentTime - lastActivity < 450L) continue;
            this.isSpeaking.put(entityId, false);
            manager = ConversationManager.getClientForEntity(entityId);
            if (manager == null) continue;
            this.scheduleSilenceTask(entityId, manager);
        }
    }
}

