/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.commands;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.StringWriter;
import java.util.List;
import me.sshcrack.gemini_live_lib.gson.properties.EnumProperty;
import me.sshcrack.gemini_live_lib.gson.properties.ObjectProperty;
import me.sshcrack.gemini_live_lib.gson.properties.PrimitiveProperty;
import me.sshcrack.gemini_live_lib.gson.properties.Property;
import me.sshcrack.mc_talking.manager.tools.AITools;
import me.sshcrack.mc_talking.manager.tools.FunctionAction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class ListToolsCommand {
    private static final SimpleCommandExceptionType NO_TOOLS = new SimpleCommandExceptionType((Message)Component.translatable((String)"mc_talking.commands.no_tools_available"));
    private static final SimpleCommandExceptionType TOOL_NOT_FOUND = new SimpleCommandExceptionType((Message)Component.translatable((String)"mc_talking.commands.tool_not_found"));

    private static int get_description(CommandContext<CommandSourceStack> context, String toolName) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)context.getSource();
        FunctionAction tool = AITools.registeredFunctions.get(toolName);
        if (tool == null) {
            throw TOOL_NOT_FOUND.create();
        }
        StringWriter strWriter = new StringWriter();
        Property prop = tool.getProperty();
        if (prop instanceof ObjectProperty) {
            ObjectProperty objProp = (ObjectProperty)prop;
            objProp.getProperties().forEach((key, value) -> {
                strWriter.write("\n");
                strWriter.write(key + ": ");
                if (value instanceof PrimitiveProperty) {
                    PrimitiveProperty prim = (PrimitiveProperty)value;
                    strWriter.write(prim.getType());
                } else if (value instanceof EnumProperty) {
                    EnumProperty enumP = (EnumProperty)value;
                    Gson gson = new Gson();
                    StringWriter s = new StringWriter();
                    gson.toJson((Object)enumP, (Appendable)s);
                    JsonElement elem = JsonParser.parseString((String)s.toString());
                    JsonArray arr = elem.getAsJsonObject().get("enum").getAsJsonArray();
                    strWriter.write(arr.toString());
                } else {
                    strWriter.write("Unsupported type");
                }
            });
        }
        src.sendSuccess(() -> Component.translatableEscape((String)"mc_talking.commands.tool_description", (Object[])new Object[]{toolName, tool.getDescription(), strWriter.toString()}), true);
        return 0;
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = Commands.literal((String)"list_tools");
        for (String fn_name : AITools.getRegisteredFunctionNames()) {
            builder.then(Commands.literal((String)fn_name).executes(context -> ListToolsCommand.get_description((CommandContext<CommandSourceStack>)context, fn_name)));
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.requires(source -> source.hasPermission(2))).executes(ctx -> {
            CommandSourceStack src = (CommandSourceStack)ctx.getSource();
            List<String> tools = AITools.getRegisteredFunctionNames();
            if (tools.isEmpty()) {
                throw NO_TOOLS.create();
            }
            src.sendSuccess(() -> Component.translatableEscape((String)"mc_talking.commands.list_tools", (Object[])new Object[]{String.join((CharSequence)", ", tools)}), true);
            return 1;
        }));
    }
}

