/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.manager.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.inventory.InventoryCitizen;
import java.util.stream.Collectors;
import me.sshcrack.mc_talking.manager.tools.FunctionAction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import org.jetbrains.annotations.NotNull;

public class GetInventoryAction
extends FunctionAction {
    public GetInventoryAction() {
        super("get_inventory", "Lists the current items in your inventory.");
    }

    @Override
    @NotNull
    public JsonObject execute(AbstractEntityCitizen citizen, IColony colony, JsonObject parameters) {
        JsonObject obj = new JsonObject();
        InventoryCitizen inv = citizen.getInventoryCitizen();
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            JsonObject itemObj = new JsonObject();
            itemObj.addProperty("slot", (Number)i);
            itemObj.addProperty("registry_id", stack.getItemHolder().getRegisteredName());
            itemObj.addProperty("name", stack.getDisplayName().getString());
            itemObj.addProperty("count", (Number)stack.getCount());
            itemObj.addProperty("max_count", (Number)stack.getMaxStackSize());
            ItemLore lore = (ItemLore)stack.get(DataComponents.LORE);
            if (lore != null) {
                itemObj.addProperty("lore", lore.lines().stream().map(Component::getString).collect(Collectors.joining("\n")));
            }
            obj.add("item_" + i, (JsonElement)itemObj);
        }
        return obj;
    }
}

