/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.UUID;
import me.sshcrack.mc_talking.ConversationManager;
import me.sshcrack.mc_talking.McTalking;
import me.sshcrack.mc_talking.config.McTalkingConfig;
import me.sshcrack.mc_talking.item.CitizenTalkingDevice;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ServerEventHandler {
    private static final TargetingConditions TARGETING_CONDITIONS = TargetingConditions.m_148353_().m_148355_();
    private int tickCounter = 0;

    @SubscribeEvent
    public void onServerStart(ServerStartingEvent event) {
        if (!((String)McTalkingConfig.CONFIG.geminiApiKey.get()).isEmpty()) {
            return;
        }
        McTalking.LOGGER.error("======================");
        McTalking.LOGGER.error("Gemini API key not set. McTalking is disabled.");
        McTalking.LOGGER.error("======================");
    }

    @SubscribeEvent
    public void onServerStop(ServerStoppingEvent event) {
        ConversationManager.cleanup();
    }

    @SubscribeEvent
    public void onPlayerJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        for (ItemStack item : player.m_150109_().f_35974_) {
            if (!(item.m_41720_() instanceof CitizenTalkingDevice)) continue;
            CompoundTag tag = item.m_41784_();
            tag.m_128405_("CustomModelData", 0);
        }
    }

    @SubscribeEvent
    public void onPlayerLeave(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ConversationManager.endConversation(player.m_20148_(), false);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter % 5 != 0) {
            return;
        }
        if (event.getServer().m_6846_().m_11314_().isEmpty()) {
            return;
        }
        for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
            UUID playerId = player.m_20148_();
            UUID citizenId = ConversationManager.getPlayerConversationPartner(playerId);
            if (citizenId != null) {
                this.checkConversationDistance(player, citizenId);
                continue;
            }
            if (((Boolean)McTalkingConfig.CONFIG.useTalkingDevice.get()).booleanValue() && !this.isHoldingTalkingDevice(player)) continue;
            this.processPlayerLooking(player);
        }
    }

    private void checkConversationDistance(ServerPlayer player, UUID citizenId) {
        AbstractEntityCitizen activeEntity = ConversationManager.getActiveEntityForPlayer(player.m_20148_());
        if (activeEntity == null || !activeEntity.m_6084_()) {
            ConversationManager.endConversation(player.m_20148_(), false);
            return;
        }
        double distanceSquared = player.m_20280_((Entity)activeEntity);
        if (distanceSquared > (Double)McTalkingConfig.CONFIG.maxConversationDistance.get() * (Double)McTalkingConfig.CONFIG.maxConversationDistance.get()) {
            ConversationManager.endConversation(player.m_20148_(), true);
        }
    }

    private void processPlayerLooking(ServerPlayer player) {
        Entity targetEntity;
        HitResult hitResult = player.m_19907_(20.0, 0.0f, false);
        UUID playerId = player.m_20148_();
        if (hitResult.m_6662_() == HitResult.Type.ENTITY && (targetEntity = ((EntityHitResult)hitResult).m_82443_()) instanceof AbstractEntityCitizen) {
            AbstractEntityCitizen citizen = (AbstractEntityCitizen)targetEntity;
            double distance = player.m_20280_(targetEntity);
            if (distance <= (Double)McTalkingConfig.CONFIG.activationDistance.get() * (Double)McTalkingConfig.CONFIG.activationDistance.get()) {
                this.processLookingAtCitizen(player, citizen);
                return;
            }
        }
        ConversationManager.setPlayerLookTarget(playerId, null);
    }

    private void processLookingAtCitizen(ServerPlayer player, AbstractEntityCitizen citizen) {
        UUID playerId = player.m_20148_();
        UUID citizenId = citizen.m_20148_();
        ConversationManager.setPlayerLookTarget(playerId, citizenId);
        ConversationManager.incrementLookDuration(playerId);
        if (ConversationManager.getPlayerLookDuration(playerId) >= (Integer)McTalkingConfig.CONFIG.lookDurationTicks.get()) {
            boolean playerIsAlone = this.isPlayerAlone(player);
            if (playerIsAlone || ((Boolean)McTalkingConfig.CONFIG.respondInGroups.get()).booleanValue()) {
                ConversationManager.startConversation(player, citizen);
                for (ItemStack item : player.m_150109_().f_35974_) {
                    if (!(item.m_41720_() instanceof CitizenTalkingDevice) || player.m_150109_().f_35977_ != player.m_150109_().m_36030_(item)) continue;
                    CompoundTag tag = item.m_41784_();
                    tag.m_128405_("CustomModelData", 1);
                    break;
                }
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"mc_talking.group_disabled").m_130940_(ChatFormatting.YELLOW));
                ConversationManager.setPlayerLookTarget(playerId, null);
            }
        }
    }

    private boolean isHoldingTalkingDevice(ServerPlayer player) {
        ItemStack heldItem = player.m_21205_();
        return heldItem.m_41720_() instanceof CitizenTalkingDevice;
    }

    private boolean isPlayerAlone(ServerPlayer player) {
        AABB boundingBox = player.m_20191_().m_82400_(5.0);
        int nearbyPlayers = player.m_9236_().m_45971_(ServerPlayer.class, TARGETING_CONDITIONS, (LivingEntity)player, boundingBox).size();
        return nearbyPlayers <= 1;
    }
}

