/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.config;

import java.util.Collections;
import java.util.List;
import me.sshcrack.mc_talking.config.AvailableAI;
import me.sshcrack.mc_talking.config.ModalityModes;
import me.sshcrack.mc_talking.manager.tools.AITools;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class McTalkingConfig {
    public static final McTalkingConfig CONFIG;
    public static final ForgeConfigSpec CONFIG_SPEC;
    public final ForgeConfigSpec.ConfigValue<String> geminiApiKey;
    public final ForgeConfigSpec.ConfigValue<AvailableAI> currentAiModel;
    public final ForgeConfigSpec.ConfigValue<String> language;
    public final ForgeConfigSpec.ConfigValue<Boolean> respondInGroups;
    public final ForgeConfigSpec.ConfigValue<Integer> lookDurationTicks;
    public final ForgeConfigSpec.ConfigValue<Integer> lookToleranceMs;
    public final ForgeConfigSpec.ConfigValue<Double> activationDistance;
    public final ForgeConfigSpec.ConfigValue<Boolean> useTalkingDevice;
    public final ForgeConfigSpec.ConfigValue<Boolean> enableFunctionWorkaround;
    public final ForgeConfigSpec.ConfigValue<Boolean> sendErrorsToPlayers;
    public final ForgeConfigSpec.ConfigValue<Integer> maxConcurrentAgents;
    public final ForgeConfigSpec.ConfigValue<Double> maxConversationDistance;
    public final ForgeConfigSpec.ConfigValue<ModalityModes> modality;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> disabledTools;

    public McTalkingConfig(ForgeConfigSpec.Builder builder) {
        this.geminiApiKey = builder.comment("API Configuration").worldRestart().comment("This key is used to authenticate with the Gemini API. You can get one at https://aistudio.google.com/apikey").define("gemini_key", (Object)"");
        this.currentAiModel = builder.worldRestart().comment("What kind of AI model to use. Flash2.5 is more advanced, more expensive but has more voices as well (not recommended for free usage). Flash2.5 burns the free tokens fast. Flash2.5 can only execute functions (for example dropping items, getting information about the colony) when Google Search is enabled.").defineEnum("ai_model", (Enum)AvailableAI.Flash2_5);
        this.enableFunctionWorkaround = builder.worldRestart().comment("Enables the Google Search so Flash2.5 can execute functions. Google Search will ONLY be enabled for Flash2.5.").define("function_workaround", true);
        this.language = builder.comment("Language Configuration").worldRestart().comment("The language the AI should use to speak").define("language", (Object)"en-US");
        this.respondInGroups = builder.worldRestart().comment("Interaction Configuration").comment("Whether the citizens should respond if the player is in a group or not.").define("respond_in_group", false);
        this.lookDurationTicks = builder.worldRestart().comment("How long the player needs to look at an entity before activating (in ticks, 20 ticks = 1 second)").define("look_duration_ticks", (Object)20);
        this.lookToleranceMs = builder.worldRestart().comment("Tolerance time in milliseconds when something walks between player and target").define("look_tolerance_ms", (Object)500);
        this.activationDistance = builder.worldRestart().comment("Distance at which the player can talk to when looking at them the citizen").define("activation_distance", (Object)3.0);
        this.useTalkingDevice = builder.worldRestart().comment("If true, citizens will only respond to the talking device item; if false, looking at them will work").define("use_talking_device", true);
        this.maxConcurrentAgents = builder.worldRestart().comment("Resource Management").comment("Maximum number of AI agents that can be activated at once (for free tier Flash2.0 this is limited to 3, for Flash2.5 to 1)").define("max_concurrent_agents", (Object)3, e -> e == null || (Integer)e > 0);
        this.maxConversationDistance = builder.worldRestart().comment("Maximum distance the player can be from a citizen before the conversation is ended").define("max_conversation_distance", (Object)8.0);
        this.modality = builder.worldRestart().comment("In which format the AI should respond. Can either be text or audio for Flash 2.0, audio only for Flash 2.5. Right now there is no support for text AND audio as far as I know (the value is still in there so it has backwards compatibility).").defineEnum("ai_modality", (Enum)ModalityModes.AUDIO);
        this.disabledTools = builder.worldRestart().comment("List of enabled tools for the AI. These tools can be used by the AI to perform actions. Available tools are listed here: https://github.com/sshcrack/talking-colonists/blob/forge-1.20.1/AVAILABLE_TOOLS.md").defineList("disabled_tools", Collections::emptyList, e -> {
            if (e instanceof String) {
                String str = (String)e;
                return AITools.getRegisteredFunctionNames().contains(str);
            }
            return false;
        });
        this.sendErrorsToPlayers = builder.comment("If true, errors will be sent to players that have OP permissions. If false, errors will only be logged to the console.").define("send_errors_to_players", true);
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(McTalkingConfig::new);
        CONFIG = (McTalkingConfig)pair.getLeft();
        CONFIG_SPEC = (ForgeConfigSpec)pair.getRight();
    }
}

