/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.manager;

import com.google.gson.JsonObject;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import me.sshcrack.gemini_live_lib.GeminiLiveClient;
import me.sshcrack.gemini_live_lib.gson.BidiGenerateContentSetup;
import me.sshcrack.gemini_live_lib.gson.ClientMessages;
import me.sshcrack.gemini_live_lib.gson.RealtimeInput;
import me.sshcrack.mc_talking.ConversationManager;
import me.sshcrack.mc_talking.McTalking;
import me.sshcrack.mc_talking.McTalkingVoicechatPlugin;
import me.sshcrack.mc_talking.capability.EntityDataProvider;
import me.sshcrack.mc_talking.config.AvailableAI;
import me.sshcrack.mc_talking.config.McTalkingConfig;
import me.sshcrack.mc_talking.config.ModalityModes;
import me.sshcrack.mc_talking.manager.CitizenContextUtils;
import me.sshcrack.mc_talking.manager.GeminiStream;
import me.sshcrack.mc_talking.manager.TalkingManager;
import me.sshcrack.mc_talking.manager.tools.AITools;
import me.sshcrack.mc_talking.manager.tools.FunctionAction;
import me.sshcrack.mc_talking.network.AiStatus;
import me.sshcrack.mc_talking.network.AiStatusPayload;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class GeminiWsClient
extends GeminiLiveClient {
    boolean setupComplete;
    boolean isInitiatingConnection = false;
    boolean shouldReconnect = false;
    GeminiStream stream;
    ServerPlayer initialPlayer;
    TalkingManager manager;
    private final List<short[]> pending_prompt = Collections.synchronizedList(new ArrayList());
    private final List<String> pendingSystemText = Collections.synchronizedList(new ArrayList());
    private String currMsg = "";
    boolean sentGeneratingStatus = false;
    long lastReconnectTime = 0L;

    public GeminiWsClient(TalkingManager manager, ServerPlayer player) {
        super((String)McTalkingConfig.CONFIG.geminiApiKey.get());
        this.manager = manager;
        this.stream = new GeminiStream((AudioChannel)manager.channel, manager.entity.m_20148_());
        boolean isFemale = manager.entity.getCitizenData().isFemale();
        boolean isChild = manager.entity.getCitizenData().isChild();
        if (isChild && !isFemale) {
            this.stream.setPitch(0.8f);
        }
        this.initialPlayer = player;
        AiStatusPayload.sendToAll(new AiStatusPayload(manager.entity.m_20148_(), AiStatus.LISTENING));
    }

    public BidiGenerateContentSetup getSetup() {
        BidiGenerateContentSetup setup = new BidiGenerateContentSetup("models/" + ((AvailableAI)((Object)McTalkingConfig.CONFIG.currentAiModel.get())).getName());
        ModalityModes modality = (ModalityModes)((Object)McTalkingConfig.CONFIG.modality.get());
        setup.generationConfig.responseModalities = modality.getModes();
        if (McTalkingConfig.CONFIG.currentAiModel.get() == AvailableAI.Flash2_5) {
            setup.generationConfig.responseModalities = List.of("AUDIO");
        }
        if (modality != ModalityModes.TEXT) {
            setup.generationConfig.speechConfig = new BidiGenerateContentSetup.GenerationConfig.SpeechConfig();
            setup.generationConfig.speechConfig.language_code = (String)McTalkingConfig.CONFIG.language.get();
            AbstractEntityCitizen entity = this.manager.entity;
            boolean female = entity.getCitizenData().isFemale();
            UUID uuid = entity.m_20148_();
            setup.sessionResumption = new BidiGenerateContentSetup.SessionResumptionConfig();
            EntityDataProvider.getFromEntity((Entity)entity).ifPresent(provider -> {
                String sessionToken = provider.getSessionToken();
                if (!sessionToken.isBlank()) {
                    setup.sessionResumption = new BidiGenerateContentSetup.SessionResumptionConfig(sessionToken);
                }
            });
            setup.generationConfig.speechConfig.voice_config = new BidiGenerateContentSetup.GenerationConfig.SpeechConfig.VoiceConfig();
            setup.generationConfig.speechConfig.voice_config.prebuiltVoiceConfig = new BidiGenerateContentSetup.GenerationConfig.SpeechConfig.PrebuiltVoiceConfig();
            setup.generationConfig.speechConfig.voice_config.prebuiltVoiceConfig.voice_name = ((AvailableAI)((Object)McTalkingConfig.CONFIG.currentAiModel.get())).getRandomVoice(uuid, female);
        }
        setup.realtimeInputConfig = new BidiGenerateContentSetup.RealtimeInputConfig();
        BidiGenerateContentSetup.SystemInstruction sys = new BidiGenerateContentSetup.SystemInstruction();
        String prompt = CitizenContextUtils.generateCitizenRoleplayPrompt(this.manager.entity.getCitizenData(), this.initialPlayer);
        BidiGenerateContentSetup.SystemInstruction.Part p = new BidiGenerateContentSetup.SystemInstruction.Part(prompt);
        sys.parts.add(p);
        setup.systemInstruction = sys;
        setup.tools.addAll(AITools.getEnabledTools());
        if (McTalkingConfig.CONFIG.currentAiModel.get() == AvailableAI.Flash2_5 && ((Boolean)McTalkingConfig.CONFIG.enableFunctionWorkaround.get()).booleanValue()) {
            setup.tools.add(BidiGenerateContentSetup.Tool.googleSearch());
        }
        return setup;
    }

    public void onUsageMetadata(JsonObject obj) {
        McTalking.LOGGER.info("Gemini usage metadata: {}", (Object)obj.toString());
    }

    public void onSessionResumptionUpdate(String newHandle, boolean resumable) {
        if (!resumable) {
            return;
        }
        EntityDataProvider.getFromEntity((Entity)this.manager.entity).ifPresent(provider -> provider.setSessionToken(newHandle));
    }

    public void onGenerationComplete() {
        McTalking.LOGGER.info("Gemini generation complete");
        this.stream.flushAudio();
        UUID player = ConversationManager.getPlayerForEntity(this.manager.entity.m_20148_());
        if (player == null) {
            return;
        }
        ServerPlayer sPlayer = this.initialPlayer.f_8924_.m_6846_().m_11259_(player);
        if (sPlayer == null || this.currMsg.isBlank()) {
            return;
        }
        sPlayer.m_213846_((Component)this.manager.entity.m_5446_().m_6881_().m_130946_(": ").m_7220_((Component)Component.m_237113_((String)this.currMsg.trim())));
        this.currMsg = "";
    }

    public void onInterrupted() {
        McTalking.LOGGER.info("Gemini generation interrupted");
        this.stream.stop();
        UUID player = ConversationManager.getPlayerForEntity(this.manager.entity.m_20148_());
        if (player == null) {
            return;
        }
        ServerPlayer sPlayer = this.initialPlayer.f_8924_.m_6846_().m_11259_(player);
        if (sPlayer == null || this.currMsg.isBlank()) {
            return;
        }
        sPlayer.m_213846_((Component)this.manager.entity.m_5446_().m_6881_().m_130946_(": ").m_7220_((Component)Component.m_237113_((String)this.currMsg.trim())));
        this.currMsg = "";
    }

    public void onGeneratedText(String text) {
        boolean hasTextEnabled;
        boolean bl = hasTextEnabled = McTalkingConfig.CONFIG.modality.get() == ModalityModes.TEXT || McTalkingConfig.CONFIG.modality.get() == ModalityModes.TEXT_AND_AUDIO;
        if (!hasTextEnabled) {
            return;
        }
        this.currMsg = this.currMsg + text;
    }

    public void onTurnComplete() {
        McTalking.LOGGER.info("Gemini turn complete");
    }

    public void onGeneratedAudio(byte[] data, int sampleRate) {
        boolean isJustStarted = this.stream.addGeminiPcmWithPitch(data, sampleRate);
        if (!isJustStarted) {
            return;
        }
        AiStatusPayload.sendToAll(new AiStatusPayload(this.manager.entity.m_20148_(), AiStatus.TALKING));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSetupComplete() {
        RealtimeInput input;
        McTalking.LOGGER.info("Gemini setup complete");
        this.setupComplete = true;
        List<String> list = this.pendingSystemText;
        synchronized (list) {
            if (!this.pendingSystemText.isEmpty()) {
                ArrayList<String> textToProcess = new ArrayList<String>(this.pendingSystemText);
                this.pendingSystemText.clear();
                for (String text : textToProcess) {
                    input = new RealtimeInput();
                    input.text = text;
                    this.send(ClientMessages.input((RealtimeInput)input));
                }
            }
        }
        list = this.pending_prompt;
        synchronized (list) {
            if (!this.pending_prompt.isEmpty()) {
                ArrayList<short[]> audioToProcess = new ArrayList<short[]>(this.pending_prompt);
                this.pending_prompt.clear();
                for (short[] data : audioToProcess) {
                    input = new RealtimeInput();
                    byte[] byteAudio = McTalkingVoicechatPlugin.vcApi.getAudioConverter().shortsToBytes(data);
                    input.audio = new RealtimeInput.Blob("audio/pcm;rate=48000", byteAudio);
                    this.send(ClientMessages.input((RealtimeInput)input));
                }
            }
        }
    }

    public JsonObject onFunctionCall(String name, @Nullable JsonObject args) {
        IColony colony = this.manager.entity.getCitizenColonyHandler().getColony();
        FunctionAction action = AITools.registeredFunctions.get(name);
        if (action == null) {
            McTalking.LOGGER.warn("Unknown function call: {}", (Object)name);
            return null;
        }
        return action.execute(this.manager.entity, colony, args);
    }

    public void onQuotaExceeded() {
        McTalking.LOGGER.warn("Quota exceeded for Gemini API, please check your API key and usage limits.");
        AiStatusPayload.sendToAll(new AiStatusPayload(this.manager.entity.m_20148_(), AiStatus.QUOTA_EXCEEDED));
        try {
            this.initialPlayer.m_213846_((Component)Component.m_237113_((String)"Quota exceeded for Gemini API, please check your API key and usage limits."));
        }
        catch (Exception e) {
            Thread.currentThread().interrupt();
        }
    }

    public void onClose(int code, String reason, boolean remote) {
        super.onClose(code, reason, remote);
        if (reason.contains("BidiGenerateContent session not found")) {
            EntityDataProvider.getFromEntity((Entity)this.manager.entity).ifPresent(provider -> provider.setSessionToken(""));
            new Thread(() -> {
                if (!this.isOpen() || !this.isInitiatingConnection) {
                    this.reconnect();
                    this.isInitiatingConnection = true;
                }
            }).start();
            return;
        }
        if (code != 1000 && code != 1001) {
            AiStatusPayload.sendToAll(new AiStatusPayload(this.manager.entity.m_20148_(), AiStatus.ERROR));
            if (this.initialPlayer.m_20310_(4) && !quotaExceeded && ((Boolean)McTalkingConfig.CONFIG.sendErrorsToPlayers.get()).booleanValue()) {
                this.initialPlayer.m_213846_((Component)Component.m_237113_((String)("An error occurred in GeminiWsClient with reason " + reason + " and code " + code)));
            }
        }
        if (code == 1000) {
            McTalking.LOGGER.info("GeminiWsClient closed normally: {}", (Object)reason);
        } else {
            McTalking.LOGGER.warn("GeminiWsClient closed: {} and code {}", (Object)reason, (Object)code);
        }
    }

    public void onError(Exception ex) {
        AiStatusPayload.sendToAll(new AiStatusPayload(this.manager.entity.m_20148_(), AiStatus.ERROR));
        if (this.initialPlayer.m_20310_(4) && ((Boolean)McTalkingConfig.CONFIG.sendErrorsToPlayers.get()).booleanValue()) {
            this.initialPlayer.m_213846_((Component)Component.m_237113_((String)("An error occurred in GeminiWsClient: " + ex.getMessage())));
        }
        McTalking.LOGGER.error("Error in GeminiWsClient: ", (Throwable)ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSystemText(String newStatusPrompt) {
        if (!this.setupComplete || this.isClosed()) {
            List<String> list = this.pendingSystemText;
            synchronized (list) {
                this.pendingSystemText.add(newStatusPrompt);
            }
            if (!this.isOpen() && !this.isInitiatingConnection) {
                if (this.shouldReconnect) {
                    if (System.currentTimeMillis() - this.lastReconnectTime < 5000L) {
                        return;
                    }
                    McTalking.LOGGER.warn("Connection lost, attempting to reconnect...");
                    this.lastReconnectTime = System.currentTimeMillis();
                    this.reconnect();
                } else {
                    this.connect();
                    this.shouldReconnect = true;
                }
                this.isInitiatingConnection = true;
            }
            return;
        }
        RealtimeInput input = new RealtimeInput();
        input.text = newStatusPrompt;
        this.send(ClientMessages.input((RealtimeInput)input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPromptAudio(short[] audio) {
        RealtimeInput input = new RealtimeInput();
        byte[] byteAudio = McTalkingVoicechatPlugin.vcApi.getAudioConverter().shortsToBytes(audio);
        input.audio = new RealtimeInput.Blob("audio/pcm;rate=48000", byteAudio);
        if (this.sentGeneratingStatus) {
            AiStatusPayload.sendToAll(new AiStatusPayload(this.manager.entity.m_20148_(), AiStatus.LISTENING));
        }
        if (!this.setupComplete || this.isClosed()) {
            List<short[]> list = this.pending_prompt;
            synchronized (list) {
                this.pending_prompt.add(audio);
            }
            if (!this.isOpen() && !this.isInitiatingConnection) {
                if (this.shouldReconnect) {
                    if (System.currentTimeMillis() - this.lastReconnectTime < 5000L) {
                        return;
                    }
                    McTalking.LOGGER.warn("Connection lost, attempting to reconnect...");
                    this.lastReconnectTime = System.currentTimeMillis();
                    this.reconnect();
                } else {
                    this.connect();
                    this.shouldReconnect = true;
                }
                this.isInitiatingConnection = true;
            }
            return;
        }
        this.send(ClientMessages.input((RealtimeInput)input));
    }

    public void close() {
        super.close();
        this.stream.close();
    }
}

