/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.manager.tools;

import com.google.gson.JsonObject;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.HashMap;
import me.sshcrack.gemini_live_lib.gson.properties.ObjectProperty;
import me.sshcrack.gemini_live_lib.gson.properties.PrimitiveProperty;
import me.sshcrack.gemini_live_lib.gson.properties.Property;
import me.sshcrack.mc_talking.manager.tools.FunctionAction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class DropItemAction
extends FunctionAction {
    public DropItemAction() {
        super("drop_item", "Drops an item with the given count at the specified slot in your inventory. Use -1 to drop the entire stack (maximum count).", (Property)new ObjectProperty((HashMap)new HashMap<String, Property>(){
            {
                this.put("slot_index", new PrimitiveProperty(PrimitiveProperty.Type.INTEGER, true));
                this.put("count", new PrimitiveProperty(PrimitiveProperty.Type.INTEGER, true));
            }
        }));
    }

    @Override
    @NotNull
    public JsonObject execute(AbstractEntityCitizen citizen, IColony colony, JsonObject parameters) {
        int count;
        JsonObject obj = new JsonObject();
        if (parameters == null || !parameters.has("slot_index") || !parameters.has("count")) {
            obj.addProperty("success", Boolean.valueOf(false));
            obj.addProperty("error", "Missing or invalid parameters.");
            return obj;
        }
        int slot_index = parameters.get("slot_index").getAsInt();
        int rCount = parameters.get("count").getAsInt();
        int n = count = rCount < 0 ? 64 : rCount;
        if (slot_index < 0 || slot_index >= citizen.getInventoryCitizen().getSlots()) {
            obj.addProperty("success", Boolean.valueOf(false));
            obj.addProperty("error", "Invalid slot index.");
            return obj;
        }
        ItemStack stack = citizen.getInventoryCitizen().getStackInSlot(slot_index);
        if (stack.m_41619_()) {
            obj.addProperty("success", Boolean.valueOf(false));
            obj.addProperty("error", "No item in the specified slot.");
            return obj;
        }
        if (count == 0 || count > stack.m_41613_()) {
            obj.addProperty("success", Boolean.valueOf(false));
            obj.addProperty("error", "Invalid count. Must be between 1 and " + stack.m_41613_() + " or negative to drop the entire stack.");
            return obj;
        }
        ItemStack droppedStack = stack.m_41777_();
        Level level = citizen.m_9236_();
        droppedStack.m_41764_(count);
        stack.m_41774_(count);
        double d0 = citizen.m_20188_() - (double)0.3f;
        ItemEntity itemEntity = new ItemEntity(level, citizen.m_20185_(), d0, citizen.m_20189_(), droppedStack);
        itemEntity.m_32010_(40);
        float sinRotX = Mth.m_14031_((float)(citizen.m_146909_() * ((float)Math.PI / 180)));
        float cosRotX = Mth.m_14089_((float)(citizen.m_146909_() * ((float)Math.PI / 180)));
        float sinRotY = Mth.m_14031_((float)(citizen.m_146908_() * ((float)Math.PI / 180)));
        float cosRotY = Mth.m_14089_((float)(citizen.m_146908_() * ((float)Math.PI / 180)));
        float random1 = citizen.m_217043_().m_188501_() * ((float)Math.PI * 2);
        float random2 = 0.02f * citizen.m_217043_().m_188501_();
        itemEntity.m_20334_((double)(-sinRotY * cosRotX * 0.3f) + Math.cos(random1) * (double)random2, (double)(-sinRotX * 0.3f + 0.1f + (citizen.m_217043_().m_188501_() - citizen.m_217043_().m_188501_()) * 0.1f), (double)(cosRotY * cosRotX * 0.3f) + Math.sin(random1) * (double)random2);
        boolean res = level.m_7967_((Entity)itemEntity);
        if (!res) {
            obj.addProperty("success", Boolean.valueOf(false));
            obj.addProperty("error", "Failed to drop the item.");
            return obj;
        }
        obj.addProperty("success", Boolean.valueOf(true));
        return obj;
    }
}

