/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.manager.tools;

import com.google.gson.JsonObject;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.HashMap;
import java.util.Optional;
import me.sshcrack.gemini_live_lib.gson.properties.ObjectProperty;
import me.sshcrack.gemini_live_lib.gson.properties.PrimitiveProperty;
import me.sshcrack.gemini_live_lib.gson.properties.Property;
import me.sshcrack.mc_talking.manager.tools.FunctionAction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GetCitizenInfoAction
extends FunctionAction {
    public GetCitizenInfoAction() {
        super("get_citizen_info", "Get information about a citizen", (Property)new ObjectProperty((HashMap)new HashMap<String, Property>(){
            {
                this.put("citizen_name", new PrimitiveProperty(PrimitiveProperty.Type.STRING, true));
            }
        }));
    }

    @Override
    @NotNull
    public JsonObject execute(AbstractEntityCitizen citizen, IColony colony, JsonObject parameters) {
        Level level = citizen.m_9236_();
        if (parameters == null || !parameters.has("citizen_name")) {
            JsonObject errorResponse = new JsonObject();
            errorResponse.addProperty("success", Boolean.valueOf(false));
            errorResponse.addProperty("error", "Missing or invalid parameters.");
            return errorResponse;
        }
        String name = parameters.get("citizen_name").getAsString();
        Optional<ICitizenData> foundOpt = colony.getCitizenManager().getCitizens().stream().filter(e -> e.getName().equals(name)).findFirst();
        if (foundOpt.isEmpty()) {
            JsonObject obj = new JsonObject();
            obj.addProperty("error", "Citizen not found.");
            return obj;
        }
        ICitizenData found = foundOpt.get();
        CompoundTag tag = (CompoundTag)found.serializeNBT();
        return this.tagToJson(tag);
    }
}

