/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.manager.tools;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.HashMap;
import java.util.List;
import me.sshcrack.gemini_live_lib.gson.properties.ObjectProperty;
import me.sshcrack.gemini_live_lib.gson.properties.PrimitiveProperty;
import me.sshcrack.gemini_live_lib.gson.properties.Property;
import me.sshcrack.mc_talking.manager.tools.FunctionAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GetColonyAction
extends FunctionAction {
    public GetColonyAction() {
        super("get_colony", "Gets information about the colony. If no colony ID is provided, it returns the colony the citizen is currently living in", (Property)new ObjectProperty((HashMap)new HashMap<String, Property>(){
            {
                this.put("colony_id", new PrimitiveProperty(PrimitiveProperty.Type.INTEGER, false));
            }
        }));
    }

    public JsonObject getColonyInfoForRoleplaying(IColony colony) {
        JsonObject colonyInfo = new JsonObject();
        colonyInfo.addProperty("id", (Number)colony.getID());
        colonyInfo.addProperty("name", colony.getName());
        colonyInfo.addProperty("dimension", colony.getDimension().m_135782_().toString());
        colonyInfo.addProperty("day", (Number)colony.getDay());
        colonyInfo.addProperty("isDay", Boolean.valueOf(colony.isDay()));
        colonyInfo.addProperty("isUnderAttack", Boolean.valueOf(colony.isColonyUnderAttack()));
        colonyInfo.addProperty("isActive", Boolean.valueOf(colony.isActive()));
        colonyInfo.addProperty("hasTownHall", Boolean.valueOf(colony.hasTownHall()));
        colonyInfo.addProperty("hasWarehouse", Boolean.valueOf(colony.hasWarehouse()));
        colonyInfo.addProperty("overallHappiness", (Number)colony.getOverallHappiness());
        colonyInfo.addProperty("citizenCount", (Number)colony.getCitizenManager().getCurrentCitizenCount());
        colonyInfo.addProperty("maxCitizens", (Number)colony.getCitizenManager().getMaxCitizens());
        colonyInfo.addProperty("structurePack", colony.getStructurePack());
        colonyInfo.addProperty("teamColor", colony.getTeamColonyColor().name());
        colonyInfo.addProperty("textureStyle", colony.getTextureStyleId());
        colonyInfo.addProperty("nameStyle", colony.getNameStyle());
        JsonArray buildingsArray = new JsonArray();
        for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
            JsonObject buildingObj = new JsonObject();
            buildingObj.addProperty("type", building.getBuildingType().getRegistryName().m_135815_());
            buildingObj.addProperty("level", (Number)building.getBuildingLevel());
            buildingObj.addProperty("position", building.getPosition().m_123344_());
            buildingsArray.add((JsonElement)buildingObj);
        }
        colonyInfo.add("buildings", (JsonElement)buildingsArray);
        JsonObject researchObj = new JsonObject();
        List completedResearchList = colony.getResearchManager().getResearchTree().getCompletedList();
        researchObj.addProperty("completedResearchCount", (Number)completedResearchList.size());
        JsonArray completedResearch = new JsonArray();
        for (Object research : completedResearchList) {
            completedResearch.add(research.toString());
        }
        researchObj.add("completedResearch", (JsonElement)completedResearch);
        colonyInfo.add("research", (JsonElement)researchObj);
        JsonObject statsObj = new JsonObject();
        statsObj.addProperty("raidCount", (Number)colony.getStatisticsManager().getStatTotal("minecolonies.raids_total"));
        for (String statType : colony.getStatisticsManager().getStatTypes()) {
            if (!statType.contains("raid") && !statType.contains("death") && !statType.contains("built") && !statType.contains("killed") && !statType.contains("produced")) continue;
            statsObj.addProperty(statType, (Number)colony.getStatisticsManager().getStatTotal(statType));
        }
        colonyInfo.add("statistics", (JsonElement)statsObj);
        JsonObject eventsObj = new JsonObject();
        eventsObj.addProperty("currentEventCount", (Number)colony.getEventManager().getEvents().size());
        colonyInfo.add("events", (JsonElement)eventsObj);
        colonyInfo.addProperty("waypointCount", (Number)colony.getWayPoints().size());
        return colonyInfo;
    }

    @Override
    @NotNull
    public JsonObject execute(AbstractEntityCitizen citizen, IColony currColony, @Nullable JsonObject parameters) {
        int id = parameters != null && parameters.has("colony_id") ? parameters.get("colony_id").getAsInt() : currColony.getID();
        IColony colony = IColonyManager.getInstance().getColonyByWorld(id, citizen.m_9236_());
        if (colony == null) {
            JsonObject errorResponse = new JsonObject();
            errorResponse.addProperty("error", "Colony not found with ID: " + id);
            return errorResponse;
        }
        return this.getColonyInfoForRoleplaying(colony);
    }
}

