/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.manager.tools;

import com.google.gson.JsonObject;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.managers.interfaces.ICitizenManager;
import com.minecolonies.api.colony.managers.interfaces.IVisitorManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.colony.buildings.modules.TavernBuildingModule;
import com.minecolonies.core.colony.interactionhandling.RecruitmentInteraction;
import me.sshcrack.mc_talking.manager.tools.FunctionAction;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class LeaveColonyAction
extends FunctionAction {
    private static final String TAG_RECRUIT_COST = "rcost";
    private static final String TAG_RECRUIT_COST_QTY = "rcostqty";

    public LeaveColonyAction() {
        super("leave_colony", "You leave the colony and become a visitor. Use this ONLY if you are REALLY unhappy and the manager doesn't care about you.");
    }

    @Override
    @NotNull
    public JsonObject execute(AbstractEntityCitizen citizen, IColony colony, JsonObject parameters) {
        ICitizenManager citizenManager = colony.getCitizenManager();
        IVisitorManager visitorManager = colony.getVisitorManager();
        IBuilding building = colony.getBuildingManager().getFirstBuildingMatching(e -> e.getBuildingType().equals(ModBuildings.tavern.get()));
        if (building == null) {
            JsonObject invalidReturn = new JsonObject();
            invalidReturn.addProperty("error", "No tavern found in the colony.");
            return invalidReturn;
        }
        TavernBuildingModule module = (TavernBuildingModule)building.getFirstModuleOccurance(TavernBuildingModule.class);
        if (module == null) {
            JsonObject invalidReturn = new JsonObject();
            invalidReturn.addProperty("error", "No tavern found in the colony.");
            return invalidReturn;
        }
        ICitizenData data = citizen.getCitizenData();
        Level level = citizen.m_9236_();
        BlockPos pos = citizen.m_20183_();
        CompoundTag citizenTag = (CompoundTag)data.serializeNBT();
        ItemStack recruitCost = Items.f_42415_.m_7968_();
        CompoundTag display = recruitCost.m_41698_("display");
        ListTag loreTag = new ListTag();
        loreTag.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237115_((String)"mc_talking.recruit_lore"))));
        display.m_128365_("Lore", (Tag)loreTag);
        recruitCost.m_41764_(16);
        citizenManager.removeCivilian((ICivilianData)data);
        citizen.m_142687_(Entity.RemovalReason.DISCARDED);
        IVisitorData visitorData = (IVisitorData)visitorManager.createAndRegisterCivilianData();
        CompoundTag itemTag = new CompoundTag();
        recruitCost.m_41739_(itemTag);
        citizenTag.m_128365_(TAG_RECRUIT_COST, (Tag)itemTag);
        citizenTag.m_128405_(TAG_RECRUIT_COST_QTY, recruitCost.m_41613_());
        BlockPosUtil.write((CompoundTag)citizenTag, (String)"sit", (BlockPos)BlockPos.f_121853_);
        citizenTag.m_128405_("id", visitorData.getId());
        visitorData.deserializeNBT((Tag)citizenTag);
        visitorData.setHomeBuilding(building);
        visitorManager.spawnOrCreateCivilian((ICivilianData)visitorData, level, pos, true);
        module.getExternalCitizens().add(visitorData.getId());
        visitorData.triggerInteraction((IInteractionResponseHandler)new RecruitmentInteraction((Component)Component.m_237110_((String)("com.minecolonies.coremod.gui.chat.recruitstory" + (level.f_46441_.m_188503_(5) + 1)), (Object[])new Object[]{visitorData.getName().split(" ")[0]}), (IChatPriority)ChatPriority.IMPORTANT));
        JsonObject obj = new JsonObject();
        obj.addProperty("success", Boolean.valueOf(true));
        return obj;
    }
}

