/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import me.sshcrack.mc_talking.config.McTalkingConfig;
import me.sshcrack.mc_talking.item.CitizenTalkingDevice;
import me.sshcrack.mc_talking.manager.TalkingManager;
import me.sshcrack.mc_talking.network.AiStatus;
import me.sshcrack.mc_talking.network.AiStatusPayload;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import net.neoforged.neoforge.network.PacketDistributor;

public class ConversationManager {
    private static final Map<UUID, AiStatus> aiStatus = new HashMap<UUID, AiStatus>();
    private static final Map<UUID, TalkingManager> clients = new HashMap<UUID, TalkingManager>();
    private static final Map<UUID, AbstractEntityCitizen> activeEntity = new HashMap<UUID, AbstractEntityCitizen>();
    private static final Map<UUID, UUID> playerConversationPartners = new HashMap<UUID, UUID>();
    private static final Queue<UUID> addedEntities = new LinkedList<UUID>();
    private static final Map<UUID, UUID> playerLookingAt = new HashMap<UUID, UUID>();
    private static final Map<UUID, Integer> lookDuration = new HashMap<UUID, Integer>();
    private static final Map<UUID, UUID> previousEntityLookedAt = new HashMap<UUID, UUID>();
    private static final Map<UUID, Long> lastEntitySwitchTime = new HashMap<UUID, Long>();

    public static void updateAiStatus(UUID entityId, AiStatus status) {
        aiStatus.put(entityId, status);
    }

    public static AiStatus getAiStatus(UUID entityId) {
        return aiStatus.getOrDefault(entityId, AiStatus.NONE);
    }

    public static Map<UUID, AiStatus> getAllAiStatus() {
        return Collections.unmodifiableMap(aiStatus);
    }

    public static void clearAiStatus() {
        aiStatus.clear();
    }

    public static void addEntity(UUID entityId) {
        TalkingManager manager;
        UUID removedEntityId;
        addedEntities.add(entityId);
        if (addedEntities.size() > (Integer)McTalkingConfig.CONFIG.maxConcurrentAgents.get() && (removedEntityId = addedEntities.poll()) != null && (manager = clients.get(removedEntityId)) != null) {
            manager.close();
            clients.remove(removedEntityId);
        }
    }

    public static void startConversation(ServerPlayer player, AbstractEntityCitizen citizen) {
        if (((String)McTalkingConfig.CONFIG.geminiApiKey.get()).isEmpty()) {
            player.sendSystemMessage((Component)Component.translatable((String)"mc_talking.no_key").withStyle(ChatFormatting.RED));
            return;
        }
        UUID playerId = player.getUUID();
        UUID citizenId = citizen.getUUID();
        activeEntity.put(playerId, citizen);
        clients.put(citizenId, new TalkingManager(citizen, player));
        ConversationManager.addEntity(citizenId);
        playerConversationPartners.put(playerId, citizenId);
    }

    public static void endConversation(UUID playerId, boolean sendMessage) {
        ServerPlayer player;
        UUID citizenId = playerConversationPartners.remove(playerId);
        if (citizenId == null) {
            return;
        }
        LivingEntity entity = (LivingEntity)activeEntity.remove(playerId);
        if (entity != null && entity.isAlive() && (player = entity.level().getServer().getPlayerList().getPlayer(playerId)) != null) {
            for (ItemStack item : player.getInventory().items) {
                if (!(item.getItem() instanceof CitizenTalkingDevice)) continue;
                item.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(0));
            }
            PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new AiStatusPayload(citizenId, AiStatus.NONE), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new AiStatusPayload(citizenId, AiStatus.NONE), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (sendMessage) {
                player.sendSystemMessage((Component)Component.translatable((String)"mc_talking.too_far").withStyle(ChatFormatting.YELLOW));
            }
        }
    }

    public static boolean isPlayerInConversation(UUID playerId) {
        return playerConversationPartners.containsKey(playerId);
    }

    public static UUID getPlayerLookTarget(UUID playerId) {
        return playerLookingAt.get(playerId);
    }

    public static void setPlayerLookTarget(UUID playerId, UUID entityId) {
        UUID previousTarget = playerLookingAt.get(playerId);
        if (entityId == null) {
            ConversationManager.resetPlayerLookTracking(playerId);
        } else if (previousTarget == null || !previousTarget.equals(entityId)) {
            ConversationManager.handleNewTargetEntity(playerId, entityId, previousTarget);
        }
    }

    public static int getPlayerLookDuration(UUID playerId) {
        return lookDuration.getOrDefault(playerId, 0);
    }

    public static void incrementLookDuration(UUID playerId) {
        lookDuration.put(playerId, ConversationManager.getPlayerLookDuration(playerId) + 1);
    }

    public static TalkingManager getClientForEntity(UUID entityId) {
        return clients.get(entityId);
    }

    public static AbstractEntityCitizen getActiveEntityForPlayer(UUID playerId) {
        return activeEntity.get(playerId);
    }

    public static UUID getPlayerForEntity(UUID entityId) {
        for (Map.Entry<UUID, AbstractEntityCitizen> entry : activeEntity.entrySet()) {
            if (!entry.getValue().getUUID().equals(entityId)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static AbstractEntityCitizen getActiveEntity(UUID playerId) {
        return activeEntity.get(playerId);
    }

    public static UUID getPlayerConversationPartner(UUID playerId) {
        return playerConversationPartners.get(playerId);
    }

    public static void checkPlayerDistances(List<ServerPlayer> players) {
        HashSet<UUID> playerIds = new HashSet<UUID>(playerConversationPartners.keySet());
        for (UUID playerId : playerIds) {
            ServerPlayer player = null;
            for (ServerPlayer serverPlayer : players) {
                if (!serverPlayer.getUUID().equals(playerId)) continue;
                player = serverPlayer;
                break;
            }
            if (player == null) {
                ConversationManager.endConversation(playerId, false);
                continue;
            }
            UUID citizenId = playerConversationPartners.get(playerId);
            if (citizenId == null) continue;
            AbstractEntityCitizen citizen = activeEntity.get(playerId);
            if (citizen == null || !citizen.isAlive()) {
                ConversationManager.endConversation(playerId, false);
                continue;
            }
            double distanceSquared = player.distanceToSqr((Entity)citizen);
            if (!(distanceSquared > (Double)McTalkingConfig.CONFIG.maxConversationDistance.get() * (Double)McTalkingConfig.CONFIG.maxConversationDistance.get())) continue;
            ConversationManager.endConversation(playerId, true);
        }
    }

    private static void handleNewTargetEntity(UUID playerId, UUID currentTargetId, UUID previousTargetId) {
        long lastSwitchTime;
        long currentTime = System.currentTimeMillis();
        UUID previousEntityId = previousEntityLookedAt.get(playerId);
        if (previousEntityId != null && previousEntityId.equals(currentTargetId) && currentTime - (lastSwitchTime = lastEntitySwitchTime.getOrDefault(playerId, 0L).longValue()) < (long)((Integer)McTalkingConfig.CONFIG.lookToleranceMs.get()).intValue()) {
            int previousDuration = lookDuration.getOrDefault(playerId, 0);
            lookDuration.put(playerId, Math.max(0, previousDuration - 5));
            playerLookingAt.put(playerId, currentTargetId);
            return;
        }
        playerLookingAt.put(playerId, currentTargetId);
        previousEntityLookedAt.put(playerId, previousTargetId);
        lastEntitySwitchTime.put(playerId, currentTime);
        lookDuration.put(playerId, 0);
        activeEntity.remove(playerId);
    }

    private static void resetPlayerLookTracking(UUID playerId) {
        UUID previousTargetId = playerLookingAt.get(playerId);
        if (previousTargetId != null) {
            previousEntityLookedAt.put(playerId, previousTargetId);
            lastEntitySwitchTime.put(playerId, System.currentTimeMillis());
        }
        playerLookingAt.remove(playerId);
        lookDuration.remove(playerId);
        activeEntity.remove(playerId);
    }

    public static void cleanup() {
        for (TalkingManager client : clients.values()) {
            client.close();
        }
        clients.clear();
        aiStatus.clear();
        activeEntity.clear();
        playerConversationPartners.clear();
        addedEntities.clear();
        playerLookingAt.clear();
        lookDuration.clear();
        previousEntityLookedAt.clear();
        lastEntitySwitchTime.clear();
    }
}

