/*
 * Decompiled with CFR 0.152.
 */
package me.sshcrack.mc_talking.manager.tools;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import me.sshcrack.gemini_live_lib.gson.properties.Property;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FunctionAction {
    private final String name;
    private final String description;
    private final Property property;

    public FunctionAction(String name, String description) {
        this(name, description, null);
    }

    public FunctionAction(String name, String description, Property property) {
        this.name = name;
        this.description = description;
        this.property = property;
    }

    public Property getProperty() {
        return this.property;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @NotNull
    public abstract JsonObject execute(AbstractEntityCitizen var1, IColony var2, @Nullable JsonObject var3);

    protected JsonObject tagToJson(CompoundTag tag) {
        return this.tagToJson((Tag)tag, (byte)10).getAsJsonObject();
    }

    protected JsonElement tagToJson(Tag tag, byte type) {
        switch (type) {
            case 10: {
                CompoundTag compound = (CompoundTag)tag;
                JsonObject obj = new JsonObject();
                for (String key : compound.getAllKeys()) {
                    JsonElement value = this.tagToJson(compound.get(key), compound.getTagType(key));
                    obj.add(key, value);
                }
                return obj;
            }
            case 9: {
                ListTag list = (ListTag)tag;
                JsonArray jsonArray = new JsonArray();
                for (Tag element : list) {
                    jsonArray.add(this.tagToJson(element, element.getId()));
                }
                return jsonArray;
            }
            case 8: {
                return new JsonPrimitive(tag.getAsString());
            }
            case 3: {
                return new JsonPrimitive((Number)((NumericTag)tag).getAsInt());
            }
            case 4: {
                return new JsonPrimitive((Number)((NumericTag)tag).getAsLong());
            }
            case 6: {
                return new JsonPrimitive((Number)((NumericTag)tag).getAsDouble());
            }
            case 1: {
                return new JsonPrimitive((Number)((NumericTag)tag).getAsByte());
            }
            case 2: {
                return new JsonPrimitive((Number)((NumericTag)tag).getAsShort());
            }
        }
        return JsonNull.INSTANCE;
    }
}

