/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.smartcrafting.event;

import com.benbenlaw.smartcrafting.item.SmartCraftingItems;
import com.benbenlaw.smartcrafting.networking.SendOpenSmartCraftingMenuToServer;
import com.benbenlaw.smartcrafting.util.KeyBinds;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@EventBusSubscriber(modid="smartcrafting", value={Dist.CLIENT})
public class OpenCraftingMenuEvent {
    @SubscribeEvent
    public static void onOpenSmartCraftingMenuButtonPressed(InputEvent.Key event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (KeyBinds.OPEN_SMART_CRAFTING_MENU_HOTKEY.consumeClick()) {
            assert (player != null);
            if (OpenCraftingMenuEvent.hasPortableSmartCraftingTable((Player)player)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SendOpenSmartCraftingMenuToServer(player.blockPosition()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"message.smartcrafting.no_portable_table"));
            }
        }
    }

    @SubscribeEvent
    public static void onOpenSmartCraftingMenuButtonPressedMouse(InputEvent.MouseButton.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (KeyBinds.OPEN_SMART_CRAFTING_MENU_HOTKEY.consumeClick()) {
            assert (player != null);
            if (OpenCraftingMenuEvent.hasPortableSmartCraftingTable((Player)player)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SendOpenSmartCraftingMenuToServer(player.blockPosition()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"message.smartcrafting.no_portable_table"));
            }
        }
    }

    private static boolean hasPortableSmartCraftingTable(Player player) {
        Optional curioApi;
        if (player.getInventory().items.stream().anyMatch(itemStack -> itemStack.getItem() == SmartCraftingItems.PORTABLE_SMART_CRAFTING_TABLE.get())) {
            return true;
        }
        if (ModList.get().isLoaded("curios") && (curioApi = CuriosApi.getCuriosInventory((LivingEntity)player)).isPresent()) {
            return ((ICuriosItemHandler)curioApi.get()).findFirstCurio((Item)SmartCraftingItems.PORTABLE_SMART_CRAFTING_TABLE.get()).isPresent();
        }
        return false;
    }
}

