/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.smartcrafting.networking.packets;

import java.util.List;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

public record SyncFavoriteRecipesClient(List<String> favorites) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncFavoriteRecipesClient> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"smartcrafting", (String)"favorite_recipes_sync_client"));
    public static final IPayloadHandler<SyncFavoriteRecipesClient> HANDLER = (pkt, ctx) -> {
        Player player = ctx.player();
        ListTag listTag = new ListTag();
        for (String fav : pkt.favorites()) {
            listTag.add((Object)StringTag.valueOf((String)fav));
        }
        player.getPersistentData().put("smart_crafting_favorites", (Tag)listTag);
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncFavoriteRecipesClient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), SyncFavoriteRecipesClient::favorites, SyncFavoriteRecipesClient::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

