/*
 * Decompiled with CFR 0.152.
 */
package com.example.minecraftplugin;

import com.example.minecraftplugin.MinecraftPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class AdminShopCommand
implements CommandExecutor,
TabCompleter {
    private final MinecraftPlugin plugin;

    public AdminShopCommand(MinecraftPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("jacobshop.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length < 1) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "setprice": {
                this.handleSetPrice(sender, args);
                break;
            }
            case "additem": {
                this.handleAddItem(sender, args);
                break;
            }
            case "removeitem": {
                this.handleRemoveItem(sender, args);
                break;
            }
            case "reload": {
                this.handleReload(sender);
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return true;
    }

    private void handleSetPrice(CommandSender sender, String[] args) {
        if (args.length != 5) {
            sender.sendMessage("\u00a7cUsage: /ashop setprice <category> <item> <buy_price> <sell_price>");
            return;
        }
        String category = args[1];
        String item = args[2];
        try {
            double buyPrice = Double.parseDouble(args[3]);
            double sellPrice = Double.parseDouble(args[4]);
            if (buyPrice < 0.0 || sellPrice < 0.0) {
                sender.sendMessage("\u00a7cPrices cannot be negative!");
                return;
            }
            ConfigurationSection categorySection = this.plugin.getConfig().getConfigurationSection("categories." + category);
            if (categorySection == null) {
                sender.sendMessage("\u00a7cCategory '" + category + "' not found!");
                return;
            }
            ConfigurationSection itemSection = categorySection.getConfigurationSection("items." + item);
            if (itemSection == null) {
                sender.sendMessage("\u00a7cItem '" + item + "' not found in category '" + category + "'!");
                return;
            }
            itemSection.set("buy-price", (Object)buyPrice);
            itemSection.set("sell-price", (Object)sellPrice);
            this.plugin.saveConfig();
            this.plugin.reloadConfig();
            sender.sendMessage("\u00a7aSuccessfully updated prices for " + item + " in category " + category);
            sender.sendMessage("\u00a7aBuy Price: $" + buyPrice + " | Sell Price: $" + sellPrice);
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid price format! Use numbers only.");
        }
    }

    private void handleAddItem(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players!");
            return;
        }
        if (args.length != 5) {
            sender.sendMessage("\u00a7cUsage: /ashop additem <category> <item_id> <buy_price> <sell_price>");
            return;
        }
        Player player = (Player)sender;
        String category = args[1];
        String itemId = args[2];
        try {
            double buyPrice = Double.parseDouble(args[3]);
            double sellPrice = Double.parseDouble(args[4]);
            if (buyPrice < 0.0 || sellPrice < 0.0) {
                sender.sendMessage("\u00a7cPrices cannot be negative!");
                return;
            }
            ConfigurationSection categorySection = this.plugin.getConfig().getConfigurationSection("categories." + category);
            if (categorySection == null) {
                sender.sendMessage("\u00a7cCategory '" + category + "' not found!");
                return;
            }
            ConfigurationSection itemsSection = categorySection.getConfigurationSection("items");
            if (itemsSection == null) {
                itemsSection = categorySection.createSection("items");
            }
            int nextSlot = 0;
            for (String key : itemsSection.getKeys(false)) {
                int slot = itemsSection.getConfigurationSection(key).getInt("slot", 0);
                if (slot < nextSlot) continue;
                nextSlot = slot + 1;
            }
            ConfigurationSection newItem = itemsSection.createSection(itemId);
            newItem.set("material", (Object)player.getInventory().getItemInMainHand().getType().name());
            newItem.set("buy-price", (Object)buyPrice);
            newItem.set("sell-price", (Object)sellPrice);
            newItem.set("slot", (Object)nextSlot);
            this.plugin.saveConfig();
            this.plugin.reloadConfig();
            sender.sendMessage("\u00a7aSuccessfully added new item to shop:");
            sender.sendMessage("\u00a7aCategory: " + category);
            sender.sendMessage("\u00a7aItem: " + itemId);
            sender.sendMessage("\u00a7aBuy Price: $" + buyPrice);
            sender.sendMessage("\u00a7aSell Price: $" + sellPrice);
            sender.sendMessage("\u00a7aSlot: " + nextSlot);
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid price format! Use numbers only.");
        }
    }

    private void handleRemoveItem(CommandSender sender, String[] args) {
        if (args.length != 3) {
            sender.sendMessage("\u00a7cUsage: /ashop removeitem <category> <item_id>");
            return;
        }
        String category = args[1];
        String itemId = args[2];
        ConfigurationSection categorySection = this.plugin.getConfig().getConfigurationSection("categories." + category);
        if (categorySection == null) {
            sender.sendMessage("\u00a7cCategory '" + category + "' not found!");
            return;
        }
        ConfigurationSection itemsSection = categorySection.getConfigurationSection("items");
        if (itemsSection == null || !itemsSection.contains(itemId)) {
            sender.sendMessage("\u00a7cItem '" + itemId + "' not found in category '" + category + "'!");
            return;
        }
        itemsSection.set(itemId, null);
        this.plugin.saveConfig();
        this.plugin.reloadConfig();
        sender.sendMessage("\u00a7aSuccessfully removed item '" + itemId + "' from category '" + category + "'");
    }

    private void handleReload(CommandSender sender) {
        this.plugin.reloadConfig();
        sender.sendMessage("\u00a7aShop configuration reloaded successfully!");
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage("\u00a76Shop Admin Commands:");
        sender.sendMessage("\u00a77/ashop setprice <category> <item> <buy_price> <sell_price> \u00a7f- Set item prices");
        sender.sendMessage("\u00a77/ashop additem <category> <item_id> <buy_price> <sell_price> \u00a7f- Add new item (hold item)");
        sender.sendMessage("\u00a77/ashop removeitem <category> <item> \u00a7f- Remove an item");
        sender.sendMessage("\u00a77/ashop reload \u00a7f- Reload shop configuration");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        Player player;
        Material heldMaterial;
        if (!sender.hasPermission("jacobshop.admin")) {
            return new ArrayList<String>();
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.addAll(Arrays.asList("setprice", "additem", "removeitem", "reload"));
        } else if (args.length == 2 && !args[0].equalsIgnoreCase("reload")) {
            ConfigurationSection categories = this.plugin.getConfig().getConfigurationSection("categories");
            if (categories != null) {
                completions.addAll(categories.getKeys(false));
            }
        } else if (args.length == 3 && (args[0].equalsIgnoreCase("setprice") || args[0].equalsIgnoreCase("removeitem"))) {
            String category = args[1];
            ConfigurationSection items = this.plugin.getConfig().getConfigurationSection("categories." + category + ".items");
            if (items != null) {
                completions.addAll(items.getKeys(false));
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("additem") && sender instanceof Player && (heldMaterial = (player = (Player)sender).getInventory().getItemInMainHand().getType()) != Material.AIR) {
            completions.add(heldMaterial.name().toLowerCase());
        }
        String currentArg = args[args.length - 1].toLowerCase();
        return completions.stream().filter(s -> s.toLowerCase().startsWith(currentArg)).collect(Collectors.toList());
    }
}

