/*
 * Decompiled with CFR 0.152.
 */
package com.example.minecraftplugin;

import com.example.minecraftplugin.AdminShopCommand;
import com.example.minecraftplugin.SellCommand;
import com.example.minecraftplugin.SellHandCommand;
import com.example.minecraftplugin.ShopCommand;
import com.example.minecraftplugin.ShopListener;
import com.example.minecraftplugin.ShopManager;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class MinecraftPlugin
extends JavaPlugin {
    private static MinecraftPlugin instance;
    private Economy economy;
    private ShopManager shopManager;
    private FileConfiguration config;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.config = this.getConfig();
        if (!this.setupEconomy()) {
            this.getLogger().severe("Vault not found! Disabling plugin.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.shopManager = new ShopManager(this);
        this.getCommand("shop").setExecutor((CommandExecutor)new ShopCommand(this));
        this.getCommand("sellhand").setExecutor((CommandExecutor)new SellHandCommand(this));
        this.getCommand("sell").setExecutor((CommandExecutor)new SellCommand(this));
        AdminShopCommand adminShopCommand = new AdminShopCommand(this);
        this.getCommand("ashop").setExecutor((CommandExecutor)adminShopCommand);
        this.getCommand("ashop").setTabCompleter((TabCompleter)adminShopCommand);
        this.getServer().getPluginManager().registerEvents((Listener)new ShopListener(this), (Plugin)this);
        this.getLogger().info("JacobShop has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("JacobShop has been disabled!");
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    public static MinecraftPlugin getInstance() {
        return instance;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public ShopManager getShopManager() {
        return this.shopManager;
    }
}

