/*
 * Decompiled with CFR 0.152.
 */
package com.example.minecraftplugin;

import com.example.minecraftplugin.MinecraftPlugin;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SellCommand
implements CommandExecutor {
    private final MinecraftPlugin plugin;

    public SellCommand(MinecraftPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("jacobshop.sell")) {
            String noPermMsg = this.plugin.getConfig().getString("messages.no-permission", "\u00a7cYou don't have permission to do that!");
            player.sendMessage(noPermMsg.replace("%prefix%", this.plugin.getConfig().getString("messages.prefix", "\u00a78[\u00a76Shop\u00a78] \u00a77")));
            return true;
        }
        boolean sellAll = args.length > 0 && args[0].equalsIgnoreCase("all");
        double totalEarnings = 0.0;
        int totalItems = 0;
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            double sellPrice;
            ItemStack item = contents[i];
            if (item == null || item.getType() == Material.AIR || (sellPrice = this.findSellPrice(item.getType())) <= 0.0) continue;
            int amount = item.getAmount();
            double itemTotal = sellPrice * (double)amount;
            player.getInventory().setItem(i, null);
            totalEarnings += itemTotal;
            totalItems += amount;
            if (!sellAll) break;
        }
        if (totalItems > 0) {
            this.plugin.getEconomy().depositPlayer((OfflinePlayer)player, totalEarnings);
            String successMsg = this.plugin.getConfig().getString("messages.sell-success", "%prefix%\u00a7aSold %amount%x items for $%price%!");
            successMsg = successMsg.replace("%prefix%", this.plugin.getConfig().getString("messages.prefix", "\u00a78[\u00a76Shop\u00a78] \u00a77")).replace("%amount%", String.valueOf(totalItems)).replace("%item%", "items").replace("%price%", String.format("%.2f", totalEarnings));
            player.sendMessage(successMsg);
        } else {
            String invalidItemMsg = this.plugin.getConfig().getString("messages.invalid-item", "%prefix%\u00a7cYou don't have any items that can be sold!");
            player.sendMessage(invalidItemMsg.replace("%prefix%", this.plugin.getConfig().getString("messages.prefix", "\u00a78[\u00a76Shop\u00a78] \u00a77")));
        }
        return true;
    }

    private double findSellPrice(Material material) {
        ConfigurationSection categoriesSection = this.plugin.getConfig().getConfigurationSection("categories");
        if (categoriesSection == null) {
            return 0.0;
        }
        for (String categoryId : categoriesSection.getKeys(false)) {
            ConfigurationSection items;
            ConfigurationSection category = categoriesSection.getConfigurationSection(categoryId);
            if (category == null || (items = category.getConfigurationSection("items")) == null) continue;
            for (String itemId : items.getKeys(false)) {
                Material itemMaterial;
                ConfigurationSection item = items.getConfigurationSection(itemId);
                if (item == null || (itemMaterial = Material.valueOf((String)item.getString("material", ""))) != material) continue;
                return item.getDouble("sell-price", 0.0);
            }
        }
        return 0.0;
    }
}

