/*
 * Decompiled with CFR 0.152.
 */
package com.example.minecraftplugin;

import com.example.minecraftplugin.MinecraftPlugin;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SellHandCommand
implements CommandExecutor {
    private final MinecraftPlugin plugin;

    public SellHandCommand(MinecraftPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("jacobshop.sell")) {
            String noPermMsg = this.plugin.getConfig().getString("messages.no-permission", "\u00a7cYou don't have permission to do that!");
            player.sendMessage(noPermMsg.replace("%prefix%", this.plugin.getConfig().getString("messages.prefix", "\u00a78[\u00a76Shop\u00a78] \u00a77")));
            return true;
        }
        ItemStack handItem = player.getInventory().getItemInMainHand();
        if (handItem.getType() == Material.AIR) {
            player.sendMessage(this.plugin.getConfig().getString("messages.prefix", "\u00a78[\u00a76Shop\u00a78] \u00a77") + "\u00a7cYou must be holding an item to sell!");
            return true;
        }
        double sellPrice = this.findSellPrice(handItem.getType());
        if (sellPrice <= 0.0) {
            String invalidItemMsg = this.plugin.getConfig().getString("messages.invalid-item", "%prefix%\u00a7cYou cannot sell this item!");
            player.sendMessage(invalidItemMsg.replace("%prefix%", this.plugin.getConfig().getString("messages.prefix", "\u00a78[\u00a76Shop\u00a78] \u00a77")));
            return true;
        }
        int amount = handItem.getAmount();
        if (args.length > 0) {
            try {
                int requestedAmount = Integer.parseInt(args[0]);
                if (requestedAmount > 0 && requestedAmount <= amount) {
                    amount = requestedAmount;
                }
            }
            catch (NumberFormatException requestedAmount) {
                // empty catch block
            }
        }
        double totalPrice = sellPrice * (double)amount;
        handItem.setAmount(handItem.getAmount() - amount);
        this.plugin.getEconomy().depositPlayer((OfflinePlayer)player, totalPrice);
        String successMsg = this.plugin.getConfig().getString("messages.sell-success", "%prefix%\u00a7aSold %amount%x %item% for $%price%!");
        successMsg = successMsg.replace("%prefix%", this.plugin.getConfig().getString("messages.prefix", "\u00a78[\u00a76Shop\u00a78] \u00a77")).replace("%amount%", String.valueOf(amount)).replace("%item%", handItem.getType().name()).replace("%price%", String.format("%.2f", totalPrice));
        player.sendMessage(successMsg);
        return true;
    }

    private double findSellPrice(Material material) {
        ConfigurationSection categoriesSection = this.plugin.getConfig().getConfigurationSection("categories");
        if (categoriesSection == null) {
            return 0.0;
        }
        for (String categoryId : categoriesSection.getKeys(false)) {
            ConfigurationSection items;
            ConfigurationSection category = categoriesSection.getConfigurationSection(categoryId);
            if (category == null || (items = category.getConfigurationSection("items")) == null) continue;
            for (String itemId : items.getKeys(false)) {
                Material itemMaterial;
                ConfigurationSection item = items.getConfigurationSection(itemId);
                if (item == null || (itemMaterial = Material.valueOf((String)item.getString("material", ""))) != material) continue;
                return item.getDouble("sell-price", 0.0);
            }
        }
        return 0.0;
    }
}

