/*
 * Decompiled with CFR 0.152.
 */
package com.example.minecraftplugin;

import com.example.minecraftplugin.MinecraftPlugin;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemStack;

public class ShopListener
implements Listener {
    private final MinecraftPlugin plugin;

    public ShopListener(MinecraftPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String guiTitle;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        String title = event.getView().getTitle();
        if (!title.startsWith(guiTitle = this.plugin.getConfig().getString("settings.gui-title", "\u00a76\u00a7lShop"))) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || !clickedItem.hasItemMeta() || !clickedItem.getItemMeta().hasDisplayName()) {
            return;
        }
        if (title.contains(" - ")) {
            this.handleItemPurchase(player, clickedItem, event.isRightClick(), event.isShiftClick());
        } else {
            this.handleCategoryClick(player, clickedItem);
        }
    }

    private void handleCategoryClick(Player player, ItemStack clickedItem) {
        ConfigurationSection categoriesSection = this.plugin.getConfig().getConfigurationSection("categories");
        if (categoriesSection == null) {
            return;
        }
        for (String categoryId : categoriesSection.getKeys(false)) {
            ConfigurationSection category = categoriesSection.getConfigurationSection(categoryId);
            if (category == null) continue;
            Material icon = Material.valueOf((String)category.getString("icon", "CHEST"));
            if (clickedItem.getType() != icon) continue;
            this.plugin.getShopManager().openCategoryMenu(player, categoryId);
            break;
        }
    }

    private void handleItemPurchase(Player player, ItemStack clickedItem, boolean rightClick, boolean shiftClick) {
        int amount = 1;
        if (rightClick) {
            amount = 64;
        } else if (shiftClick) {
            amount = 32;
        }
        this.plugin.getShopManager().handlePurchase(player, clickedItem.getType(), amount);
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        String guiTitle;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        String title = event.getView().getTitle();
        if (title.startsWith(guiTitle = this.plugin.getConfig().getString("settings.gui-title", "\u00a76\u00a7lShop"))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        String guiTitle;
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        String title = event.getView().getTitle();
        if (!title.startsWith(guiTitle = this.plugin.getConfig().getString("settings.gui-title", "\u00a76\u00a7lShop"))) {
            return;
        }
    }
}

