/*
 * Decompiled with CFR 0.152.
 */
package com.example.minecraftplugin;

import com.example.minecraftplugin.MinecraftPlugin;
import com.example.minecraftplugin.ShopCategory;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ShopManager {
    private final MinecraftPlugin plugin;
    private final Map<String, ShopCategory> categories;
    private final String guiTitle;
    private final int rows;
    private final Map<String, Long> lastTransaction;
    private static final long TRANSACTION_COOLDOWN = 500L;

    public ShopManager(MinecraftPlugin plugin) {
        this.plugin = plugin;
        this.categories = new HashMap<String, ShopCategory>();
        this.guiTitle = plugin.getConfig().getString("settings.gui-title", "\u00a76\u00a7lShop");
        this.rows = plugin.getConfig().getInt("settings.rows", 6);
        this.lastTransaction = new HashMap<String, Long>();
        this.loadCategories();
    }

    private void loadCategories() {
        ConfigurationSection categoriesSection = this.plugin.getConfig().getConfigurationSection("categories");
        if (categoriesSection == null) {
            return;
        }
        for (String categoryId : categoriesSection.getKeys(false)) {
            ConfigurationSection categorySection = categoriesSection.getConfigurationSection(categoryId);
            if (categorySection == null) continue;
            String name = categorySection.getString("name");
            Material icon = Material.valueOf((String)categorySection.getString("icon", "CHEST"));
            int slot = categorySection.getInt("slot", 0);
            this.categories.put(categoryId, new ShopCategory(categoryId, name, icon, slot));
        }
    }

    public void openMainMenu(Player player) {
        Inventory inventory = Bukkit.createInventory(null, (int)(this.rows * 9), (String)this.guiTitle);
        ItemStack filler = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        if (fillerMeta != null) {
            fillerMeta.setDisplayName(" ");
            filler.setItemMeta(fillerMeta);
        }
        for (int i = 0; i < inventory.getSize(); ++i) {
            inventory.setItem(i, filler);
        }
        ItemStack info = new ItemStack(Material.BOOK);
        ItemMeta infoMeta = info.getItemMeta();
        if (infoMeta != null) {
            infoMeta.setDisplayName("\u00a76\u00a7lShop Information");
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("\u00a77Welcome to the server shop!");
            lore.add("\u00a77Here you can buy and sell items.");
            lore.add("");
            lore.add("\u00a7e\u00a7lHow to use:");
            lore.add("\u00a77\u2022 Click on any category to view items");
            lore.add("\u00a77\u2022 Left-click to buy 1 item");
            lore.add("\u00a77\u2022 Right-click to buy 64 items");
            lore.add("\u00a77\u2022 Shift-click to buy 32 items");
            lore.add("");
            lore.add("\u00a7e\u00a7lCommands:");
            lore.add("\u00a77/shop \u00a7f- Open this menu");
            lore.add("\u00a77/sell \u00a7f- Sell items from inventory");
            lore.add("\u00a77/sellhand \u00a7f- Sell item in your hand");
            infoMeta.setLore((List)lore);
            info.setItemMeta(infoMeta);
        }
        inventory.setItem(4, info);
        for (ShopCategory category : this.categories.values()) {
            ItemStack icon = new ItemStack(category.getIcon());
            ItemMeta meta = icon.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(category.getName());
                ArrayList<String> lore = new ArrayList<String>();
                lore.add("");
                lore.add("\u00a77Click to view items in this category");
                switch (category.getId()) {
                    case "common_blocks": {
                        lore.add("\u00a77Contains basic building materials");
                        lore.add("\u00a77Perfect for starting your builds");
                        break;
                    }
                    case "uncommon_blocks": {
                        lore.add("\u00a77Contains decorative blocks");
                        lore.add("\u00a77Great for detailed builds");
                        break;
                    }
                    case "rare_blocks": {
                        lore.add("\u00a77Contains valuable blocks");
                        lore.add("\u00a77Show off your wealth!");
                        break;
                    }
                    case "tools": {
                        lore.add("\u00a77Contains various tools");
                        lore.add("\u00a77From iron to netherite");
                        break;
                    }
                    case "combat": {
                        lore.add("\u00a77Contains weapons and armor");
                        lore.add("\u00a77Prepare for battle!");
                        break;
                    }
                    case "rare_items": {
                        lore.add("\u00a77Contains special items");
                        lore.add("\u00a77The rarest items available!");
                        break;
                    }
                    case "enchanted_books": {
                        lore.add("\u00a77Contains powerful enchantments");
                        lore.add("\u00a77Upgrade your gear!");
                    }
                }
                meta.setLore(lore);
                icon.setItemMeta(meta);
            }
            inventory.setItem(category.getSlot(), icon);
        }
        ItemStack balance = new ItemStack(Material.GOLD_INGOT);
        ItemMeta balanceMeta = balance.getItemMeta();
        if (balanceMeta != null) {
            balanceMeta.setDisplayName("\u00a76\u00a7lYour Balance");
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)("\u00a77Current Balance: \u00a7a$" + String.format("%.2f", this.plugin.getEconomy().getBalance((OfflinePlayer)player)))));
            balanceMeta.setLore(lore);
            balance.setItemMeta(balanceMeta);
        }
        inventory.setItem(49, balance);
        player.openInventory(inventory);
    }

    public void openCategoryMenu(Player player, String categoryId) {
        ConfigurationSection category = this.plugin.getConfig().getConfigurationSection("categories." + categoryId);
        if (category == null) {
            return;
        }
        String categoryName = category.getString("name", "Category");
        Inventory inventory = Bukkit.createInventory(null, (int)(this.rows * 9), (String)(this.guiTitle + " - " + categoryName));
        ConfigurationSection items = category.getConfigurationSection("items");
        if (items != null) {
            for (String itemId : items.getKeys(false)) {
                ConfigurationSection itemSection = items.getConfigurationSection(itemId);
                if (itemSection == null) continue;
                Material material = Material.valueOf((String)itemSection.getString("material", "STONE"));
                double buyPrice = itemSection.getDouble("buy-price", 0.0);
                double sellPrice = itemSection.getDouble("sell-price", 0.0);
                int slot = itemSection.getInt("slot", 0);
                ItemStack item = new ItemStack(material);
                ItemMeta meta = item.getItemMeta();
                if (meta != null) {
                    meta.setDisplayName("\u00a7f" + material.name().replace("_", " "));
                    ArrayList<Object> lore = new ArrayList<Object>();
                    lore.add("\u00a77Buy Price: \u00a7a$" + String.format("%.2f", buyPrice));
                    lore.add("\u00a77Sell Price: \u00a7a$" + String.format("%.2f", sellPrice));
                    lore.add("");
                    lore.add("\u00a7eLeft-click to buy 1");
                    lore.add("\u00a7eRight-click to buy 64");
                    lore.add("\u00a7eShift-click to buy 32");
                    meta.setLore(lore);
                    item.setItemMeta(meta);
                }
                inventory.setItem(slot, item);
            }
        }
        player.openInventory(inventory);
    }

    public boolean handlePurchase(Player player, Material material, int amount) {
        String key = player.getName() + ":" + material.name();
        long lastTime = this.lastTransaction.getOrDefault(key, 0L);
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastTime < 500L) {
            player.sendMessage("\u00a7cPlease wait a moment before making another transaction!");
            return false;
        }
        double price = this.findBuyPrice(material);
        if (price <= 0.0) {
            return false;
        }
        double totalCost = price * (double)amount;
        if (!this.plugin.getEconomy().has((OfflinePlayer)player, totalCost)) {
            String insufficientFundsMsg = this.plugin.getConfig().getString("messages.insufficient-funds", "\u00a7cYou don't have enough money!");
            player.sendMessage(insufficientFundsMsg);
            return false;
        }
        if (player.getInventory().firstEmpty() == -1) {
            String inventoryFullMsg = this.plugin.getConfig().getString("messages.inventory-full", "\u00a7cYour inventory is full!");
            player.sendMessage(inventoryFullMsg);
            return false;
        }
        this.plugin.getEconomy().withdrawPlayer((OfflinePlayer)player, totalCost);
        ItemStack boughtItem = new ItemStack(material, amount);
        HashMap leftover = player.getInventory().addItem(new ItemStack[]{boughtItem});
        if (!leftover.isEmpty()) {
            int refundAmount = 0;
            for (ItemStack item : leftover.values()) {
                refundAmount += item.getAmount();
            }
            double refund = price * (double)refundAmount;
            this.plugin.getEconomy().depositPlayer((OfflinePlayer)player, refund);
            player.sendMessage("\u00a7cCouldn't give all items! Refunded $" + String.format("%.2f", refund));
            return false;
        }
        this.lastTransaction.put(key, currentTime);
        String successMsg = this.plugin.getConfig().getString("messages.purchase-success", "\u00a7aSuccessfully purchased %amount%x %item% for $%price%!");
        successMsg = successMsg.replace("%amount%", String.valueOf(amount)).replace("%item%", material.name()).replace("%price%", String.format("%.2f", totalCost));
        player.sendMessage(successMsg);
        return true;
    }

    public boolean handleSale(Player player, ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        String key = player.getName() + ":" + item.getType().name();
        long lastTime = this.lastTransaction.getOrDefault(key, 0L);
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastTime < 500L) {
            player.sendMessage("\u00a7cPlease wait a moment before making another transaction!");
            return false;
        }
        double price = this.findSellPrice(item.getType());
        if (price <= 0.0) {
            String invalidItemMsg = this.plugin.getConfig().getString("messages.invalid-item", "\u00a7cYou cannot sell this item!");
            player.sendMessage(invalidItemMsg);
            return false;
        }
        int amount = item.getAmount();
        double totalPrice = price * (double)amount;
        item.setAmount(0);
        this.plugin.getEconomy().depositPlayer((OfflinePlayer)player, totalPrice);
        this.lastTransaction.put(key, currentTime);
        String successMsg = this.plugin.getConfig().getString("messages.sell-success", "\u00a7aSold %amount%x %item% for $%price%!");
        successMsg = successMsg.replace("%amount%", String.valueOf(amount)).replace("%item%", item.getType().name()).replace("%price%", String.format("%.2f", totalPrice));
        player.sendMessage(successMsg);
        return true;
    }

    private double findBuyPrice(Material material) {
        for (String categoryId : this.categories.keySet()) {
            ConfigurationSection items = this.plugin.getConfig().getConfigurationSection("categories." + categoryId + ".items");
            if (items == null) continue;
            for (String itemId : items.getKeys(false)) {
                ConfigurationSection item = items.getConfigurationSection(itemId);
                if (item == null || material != Material.valueOf((String)item.getString("material", ""))) continue;
                return item.getDouble("buy-price", 0.0);
            }
        }
        return 0.0;
    }

    private double findSellPrice(Material material) {
        for (String categoryId : this.categories.keySet()) {
            ConfigurationSection items = this.plugin.getConfig().getConfigurationSection("categories." + categoryId + ".items");
            if (items == null) continue;
            for (String itemId : items.getKeys(false)) {
                ConfigurationSection item = items.getConfigurationSection(itemId);
                if (item == null || material != Material.valueOf((String)item.getString("material", ""))) continue;
                return item.getDouble("sell-price", 0.0);
            }
        }
        return 0.0;
    }
}

