/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.cicada.api.util;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;

public class IntRange {
    public static final IntRange ANY = new IntRange(Integer.MIN_VALUE, Integer.MAX_VALUE);
    public static final Codec<IntRange> CODEC = Codec.either((Codec)Codec.INT, (Codec)Codec.STRING).xmap(either -> (IntRange)either.map(IntRange::new, IntRange::new), range -> range.getMin() == range.getMax() ? Either.left((Object)range.getMin()) : Either.right((Object)range.toString()));
    private final int min;
    private final int max;

    public IntRange(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public IntRange(int exactly) {
        this.min = exactly;
        this.max = exactly;
    }

    public IntRange(String range) {
        if (range.equals("*")) {
            this.min = Integer.MIN_VALUE;
            this.max = Integer.MAX_VALUE;
        } else {
            String[] split = range.split("\\.\\.|-");
            if (split.length == 1) {
                this.max = this.min = Integer.parseInt(split[0]);
            } else {
                this.min = Integer.parseInt(split[0]);
                this.max = Integer.parseInt(split[1]);
            }
        }
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getRandom() {
        return (int)(Math.random() * (double)(this.max - this.min + 1) + (double)this.min);
    }

    public boolean isInRange(int value) {
        return value >= this.min && value <= this.max;
    }

    public String toString() {
        return this.min + ".." + this.max;
    }
}

