/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft;

import cc.spea.currencycraft.Config;
import cc.spea.currencycraft.blocks.ATMBlock;
import cc.spea.currencycraft.blocks.CashRegister.CashRegisterBlock;
import cc.spea.currencycraft.blocks.CashRegister.CashRegisterBlockEntity;
import cc.spea.currencycraft.blocks.VendingMachine.VendingMachineBlock;
import cc.spea.currencycraft.blocks.VendingMachine.VendingMachineBlockEntity;
import cc.spea.currencycraft.blocks.VendingMachine.VendingMachineRenderer;
import cc.spea.currencycraft.gui.ATM.ATMFingerprintMenu;
import cc.spea.currencycraft.gui.ATM.ATMFingerprintScreen;
import cc.spea.currencycraft.gui.ATM.ATMMainMenu;
import cc.spea.currencycraft.gui.ATM.ATMMainScreen;
import cc.spea.currencycraft.gui.ATM.ATMPinEntryMenu;
import cc.spea.currencycraft.gui.ATM.ATMPinEntryScreen;
import cc.spea.currencycraft.gui.ATM.ATMSetupMenu;
import cc.spea.currencycraft.gui.ATM.ATMSetupScreen;
import cc.spea.currencycraft.gui.CashRegister.CashRegisterMenu;
import cc.spea.currencycraft.gui.CashRegister.CashRegisterScreen;
import cc.spea.currencycraft.gui.VendingMachine.VendingMachinePurchaseMenu;
import cc.spea.currencycraft.gui.VendingMachine.VendingMachinePurchaseScreen;
import cc.spea.currencycraft.gui.VendingMachine.VendingMachineRestockMenu;
import cc.spea.currencycraft.gui.VendingMachine.VendingMachineRestockScreen;
import cc.spea.currencycraft.gui.Wallet.WalletMenu;
import cc.spea.currencycraft.gui.Wallet.WalletScreen;
import cc.spea.currencycraft.items.DebitCardItem;
import cc.spea.currencycraft.items.Wallet.WalletItem;
import cc.spea.currencycraft.network.ModMessages;
import cc.spea.currencycraft.sounds.ModSounds;
import cc.spea.currencycraft.villager.CurrencyCraftVillagers;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="currencycraft")
public class CurrencyCraft {
    public static final String MODID = "currencycraft";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"currencycraft");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"currencycraft");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"currencycraft");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"currencycraft");
    public static final DeferredRegister<MenuType<?>> MENUS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"currencycraft");
    public static final Map<Item, Long> CURRENCY_VALUES = new HashMap<Item, Long>();
    public static final RegistryObject<Block> ATM_BLOCK = BLOCKS.register("atm", () -> new ATMBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60955_().m_60913_(5.0f, 6.0f)));
    public static final RegistryObject<Item> ATM_BLOCK_ITEM = ITEMS.register("atm", () -> new BlockItem((Block)ATM_BLOCK.get(), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Block> VENDING_MACHINE_BLOCK = BLOCKS.register("vending_machine", () -> new VendingMachineBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283927_).m_60955_().m_60913_(50.0f, 1200.0f)));
    public static final RegistryObject<Item> VENDING_MACHINE_BLOCK_ITEM = ITEMS.register("vending_machine", () -> new BlockItem((Block)VENDING_MACHINE_BLOCK.get(), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<BlockEntityType<VendingMachineBlockEntity>> VENDING_MACHINE_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("vending_machine", () -> BlockEntityType.Builder.m_155273_(VendingMachineBlockEntity::new, (Block[])new Block[]{(Block)VENDING_MACHINE_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<Block> CASH_REGISTER_BLOCK = BLOCKS.register("cash_register", () -> new CashRegisterBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60913_(25.0f, 1200.0f)));
    public static final RegistryObject<Item> CASH_REGISTER_BLOCK_ITEM = ITEMS.register("cash_register", () -> new BlockItem((Block)CASH_REGISTER_BLOCK.get(), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<BlockEntityType<CashRegisterBlockEntity>> CASH_REGISTER_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("cash_register", () -> BlockEntityType.Builder.m_155273_(CashRegisterBlockEntity::new, (Block[])new Block[]{(Block)CASH_REGISTER_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<Item> DEBIT_CARD = ITEMS.register("debit_card", () -> new DebitCardItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> WALLET = ITEMS.register("wallet", () -> new WalletItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<MenuType<VendingMachineRestockMenu>> VENDING_MACHINE_RESTOCK_MENU = MENUS.register("vending_machine_restock", () -> IForgeMenuType.create((windowId, inv, data) -> {
        BlockPos pos = data.m_130135_();
        BlockEntity be = inv.f_35978_.m_9236_().m_7702_(pos);
        if (be instanceof VendingMachineBlockEntity) {
            VendingMachineBlockEntity vm = (VendingMachineBlockEntity)be;
            return new VendingMachineRestockMenu(windowId, inv, (Container)vm);
        }
        return null;
    }));
    public static final RegistryObject<MenuType<VendingMachinePurchaseMenu>> VENDING_MACHINE_PURCHASE_MENU = MENUS.register("vending_machine_purchase", () -> IForgeMenuType.create((windowId, inv, data) -> {
        BlockPos pos = data.m_130135_();
        BlockEntity be = inv.f_35978_.m_9236_().m_7702_(pos);
        if (be instanceof VendingMachineBlockEntity) {
            VendingMachineBlockEntity vm = (VendingMachineBlockEntity)be;
            return new VendingMachinePurchaseMenu(windowId, inv, (Container)vm);
        }
        return null;
    }));
    public static final RegistryObject<MenuType<CashRegisterMenu>> CASH_REGISTER_MENU = MENUS.register("cash_register", () -> IForgeMenuType.create((windowId, inv, data) -> {
        BlockPos pos = data.m_130135_();
        BlockEntity be = inv.f_35978_.m_9236_().m_7702_(pos);
        if (be instanceof CashRegisterBlockEntity) {
            CashRegisterBlockEntity vm = (CashRegisterBlockEntity)be;
            return new CashRegisterMenu(windowId, inv, (Container)vm, vm.getContainerData());
        }
        return null;
    }));
    public static final RegistryObject<MenuType<WalletMenu>> WALLET_MENU = MENUS.register("wallet", () -> IForgeMenuType.create((windowId, inv, data) -> {
        ItemStack itemStack = data.m_130267_();
        if (itemStack.m_150930_((Item)WALLET.get())) {
            return new WalletMenu(windowId, inv, itemStack);
        }
        return null;
    }));
    public static final RegistryObject<MenuType<ATMSetupMenu>> ATM_SETUP_MENU = MENUS.register("atm_setup", () -> IForgeMenuType.create(ATMSetupMenu::new));
    public static final RegistryObject<MenuType<ATMFingerprintMenu>> ATM_FINGERPRINT_MENU = MENUS.register("atm_fingerprint", () -> IForgeMenuType.create(ATMFingerprintMenu::new));
    public static final RegistryObject<MenuType<ATMPinEntryMenu>> ATM_PIN_ENTRY_MENU = MENUS.register("atm_pin_entry", () -> IForgeMenuType.create(ATMPinEntryMenu::new));
    public static final RegistryObject<MenuType<ATMMainMenu>> ATM_MAIN_MENU = MENUS.register("atm_main", () -> IForgeMenuType.create(ATMMainMenu::new));
    public static final String[] CURRENCY_ITEM_NAMES = new String[]{"one_cent_coin", "two_cent_coin", "five_cent_coin", "ten_cent_coin", "twenty_cent_coin", "fifty_cent_coin", "one_unit_coin", "two_unit_coin", "five_unit_note", "ten_unit_note", "twenty_unit_note", "fifty_unit_note", "one_hundred_unit_note", "two_hundred_unit_note", "five_hundred_unit_note"};
    public static final Map<String, RegistryObject<Item>> CURRENCY_ITEMS = new LinkedHashMap<String, RegistryObject<Item>>();
    public static final Map<String, RegistryObject<Item>> CURRENCYCRAFT_ITEMS = new LinkedHashMap<String, RegistryObject<Item>>();
    public static final RegistryObject<Item> FIVE_EURO_NOTE;
    public static final RegistryObject<CreativeModeTab> CURRENCYCRAFT_TAB;

    private static RegistryObject<Item> registerItem(String name) {
        return ITEMS.register(name, () -> new Item(new Item.Properties()));
    }

    public CurrencyCraft(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        BLOCK_ENTITY_TYPES.register(modEventBus);
        MENUS.register(modEventBus);
        ModSounds.register(modEventBus);
        CurrencyCraftVillagers.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private static void registerCurrencyValues() {
        CURRENCY_VALUES.put((Item)CURRENCY_ITEMS.get("one_cent_coin").get(), 1L);
        CURRENCY_VALUES.put((Item)CURRENCY_ITEMS.get("two_cent_coin").get(), 2L);
        CURRENCY_VALUES.put((Item)CURRENCY_ITEMS.get("five_cent_coin").get(), 5L);
        CURRENCY_VALUES.put((Item)CURRENCY_ITEMS.get("ten_cent_coin").get(), 10L);
        CURRENCY_VALUES.put((Item)CURRENCY_ITEMS.get("twenty_cent_coin").get(), 20L);
        CURRENCY_VALUES.put((Item)CURRENCY_ITEMS.get("fifty_cent_coin").get(), 50L);
        CURRENCY_VALUES.put((Item)CURRENCY_ITEMS.get("one_unit_coin").get(), 100L);
        CURRENCY_VALUES.put((Item)CURRENCY_ITEMS.get("two_unit_coin").get(), 200L);
        CURRENCY_VALUES.put((Item)CURRENCY_ITEMS.get("five_unit_note").get(), 500L);
        CURRENCY_VALUES.put((Item)CURRENCY_ITEMS.get("ten_unit_note").get(), 1000L);
        CURRENCY_VALUES.put((Item)CURRENCY_ITEMS.get("twenty_unit_note").get(), 2000L);
        CURRENCY_VALUES.put((Item)CURRENCY_ITEMS.get("fifty_unit_note").get(), 5000L);
        CURRENCY_VALUES.put((Item)CURRENCY_ITEMS.get("one_hundred_unit_note").get(), 10000L);
        CURRENCY_VALUES.put((Item)CURRENCY_ITEMS.get("two_hundred_unit_note").get(), 20000L);
        CURRENCY_VALUES.put((Item)CURRENCY_ITEMS.get("five_hundred_unit_note").get(), 50000L);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        CurrencyCraft.registerCurrencyValues();
        event.enqueueWork(() -> ModMessages.register());
    }

    static {
        for (String name : CURRENCY_ITEM_NAMES) {
            CURRENCYCRAFT_ITEMS.put(name, CurrencyCraft.registerItem(name));
            CURRENCY_ITEMS.put(name, CURRENCYCRAFT_ITEMS.get(name));
        }
        CURRENCYCRAFT_ITEMS.put("atm", ATM_BLOCK_ITEM);
        CURRENCYCRAFT_ITEMS.put("cash_register", CASH_REGISTER_BLOCK_ITEM);
        CURRENCYCRAFT_ITEMS.put("vending_machine", VENDING_MACHINE_BLOCK_ITEM);
        CURRENCYCRAFT_ITEMS.put("debit_card", DEBIT_CARD);
        CURRENCYCRAFT_ITEMS.put("wallet", WALLET);
        FIVE_EURO_NOTE = CURRENCYCRAFT_ITEMS.get("five_unit_note");
        CURRENCYCRAFT_TAB = CREATIVE_MODE_TABS.register("currencycraft_tab", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256797_}).m_257737_(() -> ((Item)FIVE_EURO_NOTE.get()).m_7968_()).m_257941_((Component)Component.m_237115_((String)"itemGroup.currencycraft.currencycraft_tab")).m_257501_((parameters, output) -> {
            for (RegistryObject<Item> item : CURRENCYCRAFT_ITEMS.values()) {
                output.m_246326_((ItemLike)item.get());
            }
        }).m_257652_());
    }

    @Mod.EventBusSubscriber(modid="currencycraft", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                MenuScreens.m_96206_((MenuType)((MenuType)VENDING_MACHINE_RESTOCK_MENU.get()), VendingMachineRestockScreen::new);
                MenuScreens.m_96206_((MenuType)((MenuType)VENDING_MACHINE_PURCHASE_MENU.get()), VendingMachinePurchaseScreen::new);
                MenuScreens.m_96206_((MenuType)((MenuType)CASH_REGISTER_MENU.get()), CashRegisterScreen::new);
                MenuScreens.m_96206_((MenuType)((MenuType)WALLET_MENU.get()), WalletScreen::new);
                MenuScreens.m_96206_((MenuType)((MenuType)ATM_SETUP_MENU.get()), ATMSetupScreen::new);
                MenuScreens.m_96206_((MenuType)((MenuType)ATM_FINGERPRINT_MENU.get()), ATMFingerprintScreen::new);
                MenuScreens.m_96206_((MenuType)((MenuType)ATM_PIN_ENTRY_MENU.get()), ATMPinEntryScreen::new);
                MenuScreens.m_96206_((MenuType)((MenuType)ATM_MAIN_MENU.get()), ATMMainScreen::new);
            });
        }

        @SubscribeEvent
        public static void onItemColorRegister(RegisterColorHandlersEvent.Item event) {
            event.register((stack, tintIndex) -> {
                if (tintIndex == 0) {
                    return ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack);
                }
                return 0xFFFFFF;
            }, new ItemLike[]{(ItemLike)WALLET.get()});
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)VENDING_MACHINE_BLOCK_ENTITY.get(), VendingMachineRenderer::new);
        }
    }
}

