/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.bank;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;

public class BankAccountData {
    private long balance = 0L;
    private UUID activeCardId = null;
    private String cardPin = null;

    public long getBalance() {
        return this.balance;
    }

    public void setBalance(long balance) {
        this.balance = Math.max(0L, balance);
    }

    public void deposit(long amount) {
        if (amount > 0L) {
            this.balance += amount;
        }
    }

    public boolean withdraw(long amount) {
        if (amount > 0L && this.balance >= amount) {
            this.balance -= amount;
            return true;
        }
        return false;
    }

    public UUID getActiveCardId() {
        return this.activeCardId;
    }

    public String getCardPin() {
        return this.cardPin;
    }

    public boolean hasActiveCard() {
        return this.activeCardId != null && this.cardPin != null;
    }

    public void setActiveCard(UUID cardId, String pin) {
        this.activeCardId = cardId;
        this.cardPin = pin;
    }

    public void disableActiveCard() {
        this.activeCardId = null;
        this.cardPin = null;
    }

    public boolean isCardValid(UUID cardId, String pin) {
        return this.activeCardId != null && this.activeCardId.equals(cardId) && this.cardPin != null && this.cardPin.equals(pin);
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("Balance", this.balance);
        if (this.activeCardId != null) {
            tag.m_128362_("ActiveCardId", this.activeCardId);
        }
        if (this.cardPin != null) {
            tag.m_128359_("CardPin", this.cardPin);
        }
        return tag;
    }

    public static BankAccountData load(CompoundTag tag) {
        BankAccountData data = new BankAccountData();
        data.balance = tag.m_128454_("Balance");
        if (tag.m_128403_("ActiveCardId")) {
            data.activeCardId = tag.m_128342_("ActiveCardId");
        }
        if (tag.m_128441_("CardPin")) {
            data.cardPin = tag.m_128461_("CardPin");
        }
        return data;
    }
}

