/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.bank;

import cc.spea.currencycraft.bank.BankAccountData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class BankAccountManager
extends SavedData {
    private static final String DATA_NAME = "currencycraft_bank_accounts";
    private final Map<UUID, BankAccountData> accounts = new HashMap<UUID, BankAccountData>();

    public BankAccountData getAccount(UUID playerUuid) {
        return this.accounts.computeIfAbsent(playerUuid, k -> new BankAccountData());
    }

    public static BankAccountManager get(MinecraftServer server) {
        DimensionDataStorage storage = server.m_129880_(Level.f_46428_).m_8895_();
        return (BankAccountManager)storage.m_164861_(BankAccountManager::load, BankAccountManager::new, DATA_NAME);
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag accountsList = new ListTag();
        for (Map.Entry<UUID, BankAccountData> entry : this.accounts.entrySet()) {
            CompoundTag accountTag = new CompoundTag();
            accountTag.m_128362_("PlayerUUID", entry.getKey());
            accountTag.m_128365_("AccountData", (Tag)entry.getValue().save());
            accountsList.add((Object)accountTag);
        }
        tag.m_128365_("Accounts", (Tag)accountsList);
        return tag;
    }

    public static BankAccountManager load(CompoundTag tag) {
        BankAccountManager manager = new BankAccountManager();
        ListTag accountsList = tag.m_128437_("Accounts", 10);
        for (int i = 0; i < accountsList.size(); ++i) {
            CompoundTag accountTag = accountsList.m_128728_(i);
            UUID playerUuid = accountTag.m_128342_("PlayerUUID");
            BankAccountData accountData = BankAccountData.load(accountTag.m_128469_("AccountData"));
            manager.accounts.put(playerUuid, accountData);
        }
        return manager;
    }

    public void markDirty() {
        this.m_77762_();
    }
}

