/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.blocks;

import cc.spea.currencycraft.CurrencyCraft;
import cc.spea.currencycraft.bank.BankAccountData;
import cc.spea.currencycraft.bank.BankAccountManager;
import cc.spea.currencycraft.blocks.HorizontalBlockBase;
import cc.spea.currencycraft.gui.ATM.ATMFingerprintMenu;
import cc.spea.currencycraft.gui.ATM.ATMPinEntryMenu;
import cc.spea.currencycraft.gui.ATM.ATMSetupMenu;
import cc.spea.currencycraft.items.DebitCardItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class ATMBlock
extends HorizontalBlockBase {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;

    public ATMBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HALF});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        Level level = context.m_43725_();
        return blockpos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockpos.m_7494_()).m_60629_(context) ? (BlockState)super.m_5573_(context).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER) : null;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.PASS;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ItemStack held = player.m_21120_(hand);
        if (held.m_41720_() == CurrencyCraft.DEBIT_CARD.get() && DebitCardItem.isBlankCard(held)) {
            BankAccountManager manager = BankAccountManager.get(serverPlayer.f_8924_);
            BankAccountData account = manager.getAccount(player.m_20148_());
            if (account.hasActiveCard()) {
                player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.card_already_exists"), true);
                return InteractionResult.FAIL;
            }
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return Component.m_237115_((String)"container.currencycraft.atm_setup");
                }

                public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
                    return new ATMSetupMenu(windowId, playerInventory);
                }
            });
            return InteractionResult.SUCCESS;
        }
        if (held.m_41720_() == CurrencyCraft.DEBIT_CARD.get() && DebitCardItem.isValidCard(held)) {
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return Component.m_237115_((String)"container.currencycraft.atm_pin_entry");
                }

                public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
                    return new ATMPinEntryMenu(windowId, playerInventory);
                }
            });
            return InteractionResult.SUCCESS;
        }
        if (held.m_41720_() == CurrencyCraft.DEBIT_CARD.get() && DebitCardItem.isCancelled(held)) {
            player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.card_cancelled"), true);
            return InteractionResult.FAIL;
        }
        BankAccountManager manager = BankAccountManager.get(serverPlayer.f_8924_);
        BankAccountData account = manager.getAccount(player.m_20148_());
        if (account.hasActiveCard()) {
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return Component.m_237115_((String)"container.currencycraft.atm_fingerprint");
                }

                public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
                    return new ATMFingerprintMenu(windowId, playerInventory);
                }
            });
            return InteractionResult.SUCCESS;
        }
        player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.no_card_to_disable"), true);
        return InteractionResult.FAIL;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        if (facing.m_122434_() == Direction.Axis.Y) {
            if (half == DoubleBlockHalf.LOWER && facing == Direction.UP) {
                return facingState.m_60713_((Block)this) && facingState.m_61143_(HALF) == DoubleBlockHalf.UPPER ? state : Blocks.f_50016_.m_49966_();
            }
            if (half == DoubleBlockHalf.UPPER && facing == Direction.DOWN) {
                return facingState.m_60713_((Block)this) && facingState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? state : Blocks.f_50016_.m_49966_();
            }
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        world.m_7731_(pos.m_7494_(), (BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))), 3);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        BlockPos otherPos = half == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_();
        BlockState otherState = world.m_8055_(otherPos);
        if (otherState.m_60713_((Block)this)) {
            world.m_46961_(otherPos, !player.m_7500_());
        }
        super.m_5707_(world, pos, state, player);
    }
}

