/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.blocks.CashRegister;

import cc.spea.currencycraft.CurrencyCraft;
import cc.spea.currencycraft.gui.CashRegister.CashRegisterLayout;
import cc.spea.currencycraft.gui.CashRegister.CashRegisterMenu;
import cc.spea.currencycraft.helper.ModHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.LockCode;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.registries.RegistryObject;

public class CashRegisterBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    private static final int totalSlots = 30;
    private static final int[] ALL_SLOTS = new int[30];
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            long total = CashRegisterBlockEntity.this.calculateTotalCurrencyValueInCents();
            return switch (index) {
                case 0 -> (int)(total >> 32);
                case 1 -> (int)total;
                default -> false;
            };
        }

        public void m_8050_(int index, int value) {
        }

        public int m_6499_() {
            return 2;
        }
    };

    public CashRegisterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CurrencyCraft.CASH_REGISTER_BLOCK_ENTITY.get(), pos, state);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void m_6211_() {
        this.getItems().clear();
    }

    public int m_6643_() {
        return 30;
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.getItems().get(slot);
    }

    public ItemStack m_7407_(int p_59613_, int p_59614_) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.getItems(), (int)p_59613_, (int)p_59614_);
        return itemstack;
    }

    public ItemStack m_8016_(int p_59630_) {
        return ContainerHelper.m_18966_(this.getItems(), (int)p_59630_);
    }

    public void m_6836_(int p_59616_, ItemStack p_59617_) {
        this.getItems().set(p_59616_, (Object)p_59617_);
        if (p_59617_.m_41613_() > this.m_6893_()) {
            p_59617_.m_41764_(this.m_6893_());
        }
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public boolean m_7983_() {
        return this.getItems().stream().allMatch(ItemStack::m_41619_);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.currencycraft.cash_register");
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    protected AbstractContainerMenu m_6555_(int windowId, Inventory inventory) {
        return new CashRegisterMenu(windowId, inventory, (Container)this, this.dataAccess);
    }

    public ContainerData getContainerData() {
        return this.dataAccess;
    }

    public int[] m_7071_(Direction dir) {
        if (dir == Direction.DOWN) {
            return new int[0];
        }
        return ALL_SLOTS;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        RegistryObject<Item> validItem = CashRegisterLayout.getValidItemForSlot(index);
        if (validItem != null) {
            return stack.m_150930_((Item)validItem.get());
        }
        return super.m_7013_(index, stack);
    }

    public boolean m_271862_(Container container, int slot, ItemStack stack) {
        return false;
    }

    public boolean m_7155_(int p_19235_, ItemStack p_19236_, Direction p_19237_) {
        return this.m_7013_(p_19235_, p_19236_);
    }

    public boolean m_7157_(int p_19239_, ItemStack p_19240_, Direction p_19241_) {
        return false;
    }

    protected IItemHandler createUnSidedHandler() {
        return new SidedInvWrapper((WorldlyContainer)this, Direction.UP);
    }

    public long calculateTotalCurrencyValueInCents() {
        return ModHelpers.calculateTotalCurrencyValueInCents(this.items);
    }

    public void setLock(LockCode code) {
        CompoundTag tag = new CompoundTag();
        code.m_19109_(tag);
        CompoundTag currentState = new CompoundTag();
        this.m_183515_(currentState);
        currentState.m_128391_(tag);
        this.m_142466_(currentState);
        this.m_6596_();
    }

    public LockCode getLock() {
        CompoundTag tag = new CompoundTag();
        super.m_183515_(tag);
        LockCode savedLock = LockCode.m_19111_((CompoundTag)tag);
        return savedLock;
    }

    static {
        for (int i = 0; i < ALL_SLOTS.length; ++i) {
            CashRegisterBlockEntity.ALL_SLOTS[i] = i;
        }
    }
}

