/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.blocks.VendingMachine;

import cc.spea.currencycraft.CurrencyCraft;
import cc.spea.currencycraft.blocks.HorizontalEntityBlockBase;
import cc.spea.currencycraft.blocks.VendingMachine.VendingMachineBlockEntity;
import cc.spea.currencycraft.gui.VendingMachine.VendingMachineMenuProvider;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class VendingMachineBlock
extends HorizontalEntityBlockBase {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final ResourceLocation CONTENTS = ResourceLocation.parse((String)"contents");

    public VendingMachineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HALF});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        Level level = context.m_43725_();
        return blockpos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockpos.m_7494_()).m_60629_(context) ? (BlockState)super.m_5573_(context).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER) : null;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockPos blockEntityPos = state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pos : pos.m_7495_();
        BlockEntity blockEntity = world.m_7702_(blockEntityPos);
        if (!(blockEntity instanceof VendingMachineBlockEntity)) {
            return InteractionResult.PASS;
        }
        VendingMachineBlockEntity vendingMachine = (VendingMachineBlockEntity)blockEntity;
        ItemStack heldStack = player.m_21120_(hand);
        if (heldStack.m_41788_() && vendingMachine.getLock().equals(LockCode.f_19102_)) {
            if (!world.m_5776_()) {
                LockCode newLock = new LockCode(heldStack.m_41786_().getString());
                vendingMachine.setLock(newLock);
                player.m_5661_((Component)Component.m_237115_((String)"container.currencycraft.vending_machine.locked"), true);
                world.m_5594_(null, pos, SoundEvents.f_12055_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (!world.m_5776_()) {
            VendingMachineMenuProvider menuProvider;
            boolean success;
            boolean isCurrency = CurrencyCraft.CURRENCY_ITEMS.values().stream().anyMatch(ro -> ro.get() == heldStack.m_41720_());
            ItemStack heldStackCopy = heldStack.m_41777_();
            heldStackCopy.m_41764_(1);
            if (isCurrency && (success = vendingMachine.addCurrency(heldStackCopy))) {
                if (!player.m_7500_()) {
                    heldStack.m_41764_(heldStack.m_41613_() - 1);
                }
                return InteractionResult.CONSUME;
            }
            if (vendingMachine.getLock().m_19107_(player.m_21205_())) {
                vendingMachine.clearOutOfOrder();
                menuProvider = new VendingMachineMenuProvider(vendingMachine, true);
            } else {
                menuProvider = new VendingMachineMenuProvider(vendingMachine, false);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)menuProvider, (BlockPos)blockEntityPos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public MenuProvider m_7246_(BlockState state, Level world, BlockPos pos) {
        BlockPos blockEntityPos = state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pos : pos.m_7495_();
        BlockEntity blockEntity = world.m_7702_(blockEntityPos);
        return blockEntity instanceof MenuProvider ? (MenuProvider)blockEntity : null;
    }

    public BlockState m_7417_(BlockState p_52796_, Direction p_52797_, BlockState p_52798_, LevelAccessor p_52799_, BlockPos p_52800_, BlockPos p_52801_) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)p_52796_.m_61143_(HALF);
        if (p_52797_.m_122434_() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (p_52797_ == Direction.UP)) {
            return p_52798_.m_60713_((Block)this) && p_52798_.m_61143_(HALF) != doubleblockhalf ? (BlockState)p_52796_.m_61124_((Property)FACING, (Comparable)((Direction)p_52798_.m_61143_((Property)FACING))) : Blocks.f_50016_.m_49966_();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && p_52797_ == Direction.DOWN && !p_52796_.m_60710_((LevelReader)p_52799_, p_52800_) ? Blocks.f_50016_.m_49966_() : super.m_7417_(p_52796_, p_52797_, p_52798_, p_52799_, p_52800_, p_52801_);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockentity;
        world.m_7731_(pos.m_7494_(), (BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))), 3);
        if (stack.m_41788_() && (blockentity = world.m_7702_(pos)) instanceof VendingMachineBlockEntity) {
            VendingMachineBlockEntity vendingmachineblockentity = (VendingMachineBlockEntity)blockentity;
            vendingmachineblockentity.m_58638_(stack.m_41786_());
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos bottomPos = state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pos : pos.m_7495_();
        BlockEntity blockEntity = level.m_7702_(bottomPos);
        if (blockEntity instanceof VendingMachineBlockEntity) {
            VendingMachineBlockEntity vendingmachineblockentity = (VendingMachineBlockEntity)blockEntity;
            if (!level.f_46443_ && player.m_7500_() && !vendingmachineblockentity.m_7983_()) {
                ItemStack itemstack = this.m_5456_().m_7968_();
                blockEntity.m_187476_(itemstack);
                if (vendingmachineblockentity.m_8077_()) {
                    itemstack.m_41714_(vendingmachineblockentity.m_7770_());
                }
                ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
                itementity.m_32060_();
                level.m_7967_((Entity)itementity);
            }
        }
        if (!level.f_46443_ && !player.m_7500_() && blockEntity instanceof VendingMachineBlockEntity) {
            VendingMachineBlockEntity vendingMachineBlockEntity = (VendingMachineBlockEntity)blockEntity;
            ItemStack itemStack = new ItemStack((ItemLike)this);
            vendingMachineBlockEntity.m_187476_(itemStack);
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemStack);
            itemEntity.m_32060_();
            level.m_7967_((Entity)itemEntity);
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState blockState, Level world, BlockPos blockPos, BlockState newBlockState, boolean isMoving) {
        if (!blockState.m_60713_(newBlockState.m_60734_())) {
            BlockEntity blockEntity;
            if (blockState.m_61143_(HALF) == DoubleBlockHalf.LOWER && (blockEntity = world.m_7702_(blockPos)) instanceof VendingMachineBlockEntity) {
                VendingMachineBlockEntity vendingMachine = (VendingMachineBlockEntity)blockEntity;
                vendingMachine.dropCurrencyContents();
                world.m_46717_(blockPos, blockState.m_60734_());
            }
            super.m_6810_(blockState, world, blockPos, newBlockState, isMoving);
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        if (params.m_287159_(LootContextParams.f_81455_) instanceof Player) {
            return Collections.emptyList();
        }
        return super.m_49635_(state, params);
    }

    public boolean m_7278_(BlockState state) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        return half == DoubleBlockHalf.LOWER;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof VendingMachineBlockEntity) {
            VendingMachineBlockEntity container = (VendingMachineBlockEntity)blockEntity;
            int slotsToCheck = container.getProductSlots();
            float totalFullness = 0.0f;
            for (int i = 0; i < slotsToCheck; ++i) {
                ItemStack itemStack = container.m_8020_(i);
                if (itemStack.m_41619_()) continue;
                totalFullness += (float)itemStack.m_41613_() / (float)Math.min(container.m_6893_(), itemStack.m_41741_());
            }
            float averageFullness = totalFullness / (float)slotsToCheck;
            return Mth.m_14143_((float)(averageFullness * 14.0f)) + (averageFullness > 0.0f ? 1 : 0);
        }
        return 0;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_5871_(ItemStack p_56193_, @Nullable BlockGetter p_56194_, List<Component> p_56195_, TooltipFlag p_56196_) {
        super.m_5871_(p_56193_, p_56194_, p_56195_, p_56196_);
        CompoundTag compoundtag = BlockItem.m_186336_((ItemStack)p_56193_);
        if (compoundtag != null && compoundtag.m_128425_("Items", 9)) {
            NonNullList nonnulllist = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)compoundtag, (NonNullList)nonnulllist);
            int i = 0;
            int j = 0;
            for (ItemStack itemstack : nonnulllist) {
                if (itemstack.m_41619_()) continue;
                ++j;
                if (i > 4) continue;
                ++i;
                MutableComponent mutablecomponent = itemstack.m_41786_().m_6881_();
                mutablecomponent.m_130946_(" x").m_130946_(String.valueOf(itemstack.m_41613_()));
                p_56195_.add((Component)mutablecomponent);
            }
            if (j - i > 0) {
                p_56195_.add((Component)Component.m_237110_((String)"container.shulkerBox.more", (Object[])new Object[]{j - i}).m_130940_(ChatFormatting.ITALIC));
            }
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        VendingMachineBlockEntity be;
        VendingMachineBlockEntity vendingMachineBlockEntity = be = state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? new VendingMachineBlockEntity(pos, state) : null;
        if (be != null) {
            be.m_6596_();
        }
        return be;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return null;
        }
        return VendingMachineBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)CurrencyCraft.VENDING_MACHINE_BLOCK_ENTITY.get()), (lvl, pos, st, be) -> be.tick(lvl, pos, st));
    }
}

