/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.blocks.VendingMachine;

import cc.spea.currencycraft.CurrencyCraft;
import cc.spea.currencycraft.helper.ModHelpers;
import cc.spea.currencycraft.sounds.ModSounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.LockCode;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class VendingMachineBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    private long insertedValueInCents = 0L;
    private int ejectTimer = 0;
    private static final int EJECT_DELAY_TICKS = 600;
    private boolean outOfOrder = false;
    private final int productSlots = 12;
    private static final int totalSlots = 37;
    private long[] productPrices = new long[12];
    private static final int[] ALL_SLOTS = new int[37];

    public VendingMachineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CurrencyCraft.VENDING_MACHINE_BLOCK_ENTITY.get(), pos, state);
    }

    public long getPriceInCents(int slot) {
        if (slot >= 0 && slot < this.productSlots) {
            return this.productPrices[slot];
        }
        return 0L;
    }

    public void setPriceInCents(int slot, long price) {
        if (slot >= 0 && slot < this.productSlots) {
            this.productPrices[slot] = price;
            this.m_6596_();
        }
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void m_6211_() {
        this.getItems().clear();
    }

    public int m_6643_() {
        return 37;
    }

    public int getProductSlots() {
        return this.productSlots;
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.getItems().get(slot);
    }

    public ItemStack m_7407_(int p_59613_, int p_59614_) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.getItems(), (int)p_59613_, (int)p_59614_);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
        }
        return itemstack;
    }

    public ItemStack m_8016_(int p_59630_) {
        return ContainerHelper.m_18966_(this.getItems(), (int)p_59630_);
    }

    public void m_6836_(int p_59616_, ItemStack p_59617_) {
        this.getItems().set(p_59616_, (Object)p_59617_);
        if (p_59617_.m_41613_() > this.m_6893_()) {
            p_59617_.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public boolean m_7983_() {
        return this.getItems().stream().allMatch(ItemStack::m_41619_);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.currencycraft.vending_machine");
    }

    public void m_142466_(CompoundTag tag) {
        long[] loadedPrices;
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        if (tag.m_128441_("InsertedValueInCents")) {
            this.insertedValueInCents = tag.m_128454_("InsertedValueInCents");
        }
        if (tag.m_128441_("EjectTimer")) {
            this.ejectTimer = tag.m_128451_("EjectTimer");
        }
        if (tag.m_128441_("OutOfOrder")) {
            this.outOfOrder = tag.m_128471_("OutOfOrder");
        }
        if (tag.m_128425_("ProductPrices", 12) && (loadedPrices = tag.m_128467_("ProductPrices")).length == this.productSlots) {
            this.productPrices = loadedPrices;
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128356_("InsertedValueInCents", this.insertedValueInCents);
        tag.m_128405_("EjectTimer", this.ejectTimer);
        tag.m_128379_("OutOfOrder", this.outOfOrder);
        tag.m_128388_("ProductPrices", this.productPrices);
    }

    public void m_6596_() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
        super.m_6596_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag nbt) {
        this.m_142466_(nbt);
    }

    public int[] m_7071_(Direction dir) {
        if (dir == Direction.DOWN) {
            return new int[0];
        }
        return ALL_SLOTS;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index >= this.getProductSlots()) {
            if (stack == null || stack.m_41619_()) {
                return false;
            }
            return CurrencyCraft.CURRENCY_ITEMS.values().stream().anyMatch(registryObject -> registryObject.get() == stack.m_41720_());
        }
        return super.m_7013_(index, stack);
    }

    public boolean m_271862_(Container container, int slot, ItemStack stack) {
        return false;
    }

    public boolean m_7155_(int p_19235_, ItemStack p_19236_, Direction p_19237_) {
        return this.m_7013_(p_19235_, p_19236_);
    }

    public boolean m_7157_(int p_19239_, ItemStack p_19240_, Direction p_19241_) {
        return false;
    }

    protected IItemHandler createUnSidedHandler() {
        return new SidedInvWrapper((WorldlyContainer)this, Direction.UP);
    }

    public boolean addCurrency(ItemStack currencyStack) {
        if (currencyStack.m_41619_()) {
            return false;
        }
        long value = ModHelpers.calculateTotalCurrencyValueInCents(List.of(currencyStack));
        this.insertedValueInCents += value;
        this.ejectTimer = 600;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (value >= 500L) {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.VENDING_MACHINE_INSERT_NOTE.get(), SoundSource.BLOCKS, 0.7f, 1.0f);
            } else {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.VENDING_MACHINE_INSERT_COIN.get(), SoundSource.BLOCKS, 0.7f, 1.0f);
            }
        }
        return true;
    }

    public void dropCurrencyContents() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState blockState = this.m_58900_();
            Direction facingDirection = (Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            BlockPos dropPosition = this.m_58899_().m_121945_(facingDirection);
            Containers.m_19010_((Level)this.f_58857_, (BlockPos)dropPosition, ModHelpers.calculateItemStacksFromCents(this.insertedValueInCents));
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.VENDING_MACHINE_CHANGE.get(), SoundSource.BLOCKS, 0.7f, 1.0f);
        }
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.ejectTimer > 0) {
            --this.ejectTimer;
            if (this.ejectTimer == 0 && this.insertedValueInCents > 0L) {
                this.dropCurrencyContents();
                this.insertedValueInCents = 0L;
                this.m_6596_();
            }
        }
    }

    public long calculateTotalCurrencyValueInCents() {
        return this.insertedValueInCents;
    }

    public boolean isOutOfOrder() {
        return this.outOfOrder;
    }

    public void setOutOfOrder(boolean outOfOrder) {
        this.outOfOrder = outOfOrder;
        this.m_6596_();
    }

    public void clearOutOfOrder() {
        if (this.outOfOrder) {
            this.outOfOrder = false;
            this.m_6596_();
        }
    }

    private boolean canFitCurrency(NonNullList<ItemStack> currencyStacks) {
        NonNullList tempInventory = NonNullList.m_122779_();
        for (int i = 12; i < this.items.size(); ++i) {
            tempInventory.add((Object)((ItemStack)this.items.get(i)).m_41777_());
        }
        for (ItemStack stackToAdd : currencyStacks) {
            int i;
            if (stackToAdd.m_41619_()) continue;
            ItemStack stackToInsert = stackToAdd.m_41777_();
            for (i = 0; i < tempInventory.size(); ++i) {
                int transferAmount;
                ItemStack slotStack = (ItemStack)tempInventory.get(i);
                if (!slotStack.m_41619_() && ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)stackToInsert) && (transferAmount = Math.min(stackToInsert.m_41613_(), slotStack.m_41741_() - slotStack.m_41613_())) > 0) {
                    slotStack.m_41769_(transferAmount);
                    stackToInsert.m_41774_(transferAmount);
                }
                if (stackToInsert.m_41619_()) break;
            }
            if (!stackToInsert.m_41619_()) {
                for (i = 0; i < tempInventory.size(); ++i) {
                    if (!((ItemStack)tempInventory.get(i)).m_41619_()) continue;
                    tempInventory.set(i, (Object)stackToInsert);
                    stackToInsert = ItemStack.f_41583_;
                    break;
                }
            }
            if (stackToInsert.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean purchaseItem(int slotIndex) {
        if (this.insertedValueInCents < this.productPrices[slotIndex]) {
            return false;
        }
        ItemStack itemStack = (ItemStack)this.items.get(slotIndex);
        if (itemStack.m_41619_()) {
            return false;
        }
        NonNullList<ItemStack> salesStacks = ModHelpers.calculateItemStacksFromCents(this.productPrices[slotIndex]);
        if (!this.canFitCurrency(salesStacks)) {
            this.setOutOfOrder(true);
            return false;
        }
        this.insertedValueInCents -= this.productPrices[slotIndex];
        BlockState blockState = this.m_58900_();
        Direction facingDirection = (Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        BlockPos dropPosition = this.m_58899_().m_121945_(facingDirection);
        NonNullList remainingItems = NonNullList.m_122779_();
        for (ItemStack stackToAdd : salesStacks) {
            int i;
            if (stackToAdd.m_41619_()) continue;
            ItemStack stackToInsert = stackToAdd.m_41777_();
            for (i = 12; i < this.items.size(); ++i) {
                int transferAmount;
                ItemStack slotStack = (ItemStack)this.items.get(i);
                if (!slotStack.m_41619_() && ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)stackToInsert) && (transferAmount = Math.min(stackToInsert.m_41613_(), slotStack.m_41741_() - slotStack.m_41613_())) > 0) {
                    slotStack.m_41769_(transferAmount);
                    stackToInsert.m_41774_(transferAmount);
                }
                if (stackToInsert.m_41619_()) break;
            }
            if (!stackToInsert.m_41619_()) {
                for (i = 12; i < this.items.size(); ++i) {
                    if (!((ItemStack)this.items.get(i)).m_41619_()) continue;
                    this.items.set(i, (Object)stackToInsert);
                    stackToInsert = ItemStack.f_41583_;
                    break;
                }
            }
            if (stackToInsert.m_41619_()) continue;
            remainingItems.add((Object)stackToInsert);
        }
        if (!remainingItems.isEmpty()) {
            Containers.m_19010_((Level)this.f_58857_, (BlockPos)dropPosition, (NonNullList)remainingItems);
        }
        ItemStack copyStack = itemStack.m_255036_(1);
        itemStack.m_41764_(itemStack.m_41613_() - 1);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            Containers.m_19010_((Level)this.f_58857_, (BlockPos)dropPosition, (NonNullList)NonNullList.m_122780_((int)1, (Object)copyStack));
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.VENDING_MACHINE_DISPENSE.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
        }
        this.ejectTimer = 600;
        this.m_6596_();
        return true;
    }

    public void setLock(LockCode code) {
        CompoundTag tag = new CompoundTag();
        code.m_19109_(tag);
        CompoundTag currentState = new CompoundTag();
        this.m_183515_(currentState);
        currentState.m_128391_(tag);
        this.m_142466_(currentState);
        this.m_6596_();
    }

    public LockCode getLock() {
        CompoundTag tag = new CompoundTag();
        super.m_183515_(tag);
        LockCode savedLock = LockCode.m_19111_((CompoundTag)tag);
        return savedLock;
    }

    protected AbstractContainerMenu m_6555_(int p_58627_, Inventory p_58628_) {
        return null;
    }

    static {
        for (int i = 0; i < ALL_SLOTS.length; ++i) {
            VendingMachineBlockEntity.ALL_SLOTS[i] = i;
        }
    }
}

