/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.datagen;

import cc.spea.currencycraft.CurrencyCraft;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    private static final int[] DENOMINATIONS = new int[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000, 50000};
    private static final String[] DENOMINATION_NAMES = new String[]{"one_cent_coin", "two_cent_coin", "five_cent_coin", "ten_cent_coin", "twenty_cent_coin", "fifty_cent_coin", "one_unit_coin", "two_unit_coin", "five_unit_note", "ten_unit_note", "twenty_unit_note", "fifty_unit_note", "one_hundred_unit_note", "two_hundred_unit_note", "five_hundred_unit_note"};

    public ModRecipeProvider(PackOutput output) {
        super(output);
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        this.generateExchangeDownRecipes(consumer);
        this.generateExchangeUpRecipes(consumer);
    }

    private void generateExchangeDownRecipes(Consumer<FinishedRecipe> consumer) {
        block0: for (int i = DENOMINATIONS.length - 1; i >= 0; --i) {
            for (int j = i - 1; j >= 0; --j) {
                if ((float)DENOMINATIONS[i] / (float)DENOMINATIONS[j] % 1.0f != 0.0f) continue;
                Item higherValueItem = this.getItemByName(DENOMINATION_NAMES[i]);
                Item lowerValueItem = this.getItemByName(DENOMINATION_NAMES[j]);
                int count = DENOMINATIONS[i] / DENOMINATIONS[j];
                ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)lowerValueItem, (int)count).m_126209_((ItemLike)higherValueItem).m_126145_("currencycraft." + DENOMINATION_NAMES[i] + "_exchange_down").m_126132_("has_" + DENOMINATION_NAMES[i], (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)higherValueItem)).m_126140_(consumer, ResourceLocation.fromNamespaceAndPath((String)"currencycraft", (String)(DENOMINATION_NAMES[j] + "_from_" + DENOMINATION_NAMES[i])));
                continue block0;
            }
        }
    }

    private void generateExchangeUpRecipes(Consumer<FinishedRecipe> consumer) {
        AtomicInteger recipeCounter = new AtomicInteger(0);
        for (int i = 0; i < DENOMINATIONS.length; ++i) {
            ArrayList<Integer> combination = new ArrayList<Integer>();
            this.findCombinations(DENOMINATIONS[i], DENOMINATIONS[i], 0, combination, 0, consumer, recipeCounter);
        }
    }

    private void findCombinations(int originalTargetValue, int remainingTarget, int startIndex, List<Integer> currentCombination, int coinCount, Consumer<FinishedRecipe> consumer, AtomicInteger counter) {
        if (remainingTarget == 0) {
            if (coinCount > 1 && coinCount <= 9) {
                this.saveCombinationRecipe(originalTargetValue, currentCombination, consumer, counter.getAndIncrement());
            }
            return;
        }
        if (remainingTarget < 0 || coinCount >= 9) {
            return;
        }
        for (int i = startIndex; i < DENOMINATIONS.length; ++i) {
            if (DENOMINATIONS[i] > remainingTarget) continue;
            currentCombination.add(DENOMINATIONS[i]);
            this.findCombinations(originalTargetValue, remainingTarget - DENOMINATIONS[i], i, currentCombination, coinCount + 1, consumer, counter);
            currentCombination.remove(currentCombination.size() - 1);
        }
    }

    private void saveCombinationRecipe(int originalTargetValue, List<Integer> ingredients, Consumer<FinishedRecipe> consumer, int recipeId) {
        String resultItemName = DENOMINATION_NAMES[this.getIndex(originalTargetValue)];
        Item resultItem = this.getItemByName(resultItemName);
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)resultItem, (int)1);
        for (int ingredientValue : ingredients) {
            builder.m_126209_((ItemLike)this.getItemByName(DENOMINATION_NAMES[this.getIndex(ingredientValue)]));
        }
        String recipeName = resultItemName + "_crafting_" + recipeId;
        builder.m_126145_("currencycraft." + resultItemName + "_exchange_up");
        builder.m_126132_("has_" + DENOMINATION_NAMES[this.getIndex(ingredients.get(0))], (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)this.getItemByName(DENOMINATION_NAMES[this.getIndex(ingredients.get(0))]))).m_126140_(consumer, ResourceLocation.fromNamespaceAndPath((String)"currencycraft", (String)recipeName));
    }

    private Item getItemByName(String name) {
        return (Item)CurrencyCraft.CURRENCY_ITEMS.get(name).get();
    }

    private int getIndex(int num) {
        for (int i = 0; i < DENOMINATIONS.length; ++i) {
            if (num != DENOMINATIONS[i]) continue;
            return i;
        }
        return -1;
    }
}

