/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.event;

import cc.spea.currencycraft.CurrencyCraft;
import cc.spea.currencycraft.villager.CurrencyCraftVillagers;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="currencycraft")
public class ModEvents {
    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        if (event.getType() == CurrencyCraftVillagers.BANKER.get()) {
            Int2ObjectMap trades = event.getTrades();
            ImmutableList mobHeadsList = ImmutableList.of(() -> Items.f_42678_, () -> Items.f_42679_, () -> Items.f_42681_, () -> Items.f_42682_, () -> Items.f_260451_, () -> Items.f_42683_);
            ((List)trades.get(1)).add(new BuyRandomItemFromTagTrade((TagKey<Item>)ItemTags.f_13168_, 64, () -> new ItemStack((ItemLike)ModEvents.getCurrency("ten_cent_coin"), 4), 16, 2, 0.05f));
            ((List)trades.get(1)).add(new BuyRandomItemFromTagTrade((TagKey<Item>)ItemTags.f_13182_, 16, () -> new ItemStack((ItemLike)ModEvents.getCurrency("twenty_cent_coin"), 5), 16, 5, 0.05f));
            ((List)trades.get(1)).add(ModEvents.createBuyTrade(() -> Items.f_42413_, 8, () -> new ItemStack((ItemLike)ModEvents.getCurrency("fifty_cent_coin"), 2), 16, 5, 0.05f));
            ((List)trades.get(2)).add(ModEvents.createBuyTrade(() -> Items.f_151052_, 6, () -> new ItemStack((ItemLike)ModEvents.getCurrency("one_unit_coin"), 4), 16, 10, 0.05f));
            ((List)trades.get(2)).add(ModEvents.createBuyTrade(() -> Items.f_42416_, 5, () -> new ItemStack((ItemLike)ModEvents.getCurrency("one_unit_coin"), 5), 16, 10, 0.05f));
            ((List)trades.get(3)).add(ModEvents.createBuyTrade(() -> Items.f_42417_, 5, () -> new ItemStack((ItemLike)ModEvents.getCurrency("five_unit_note"), 5), 12, 15, 0.05f));
            ((List)trades.get(3)).add(new SellRandomItemFromTagTrade(() -> new ItemStack((ItemLike)ModEvents.getCurrency("fifty_unit_note"), 10), (TagKey<Item>)ItemTags.f_13158_, 1, 3, 15, 0.05f));
            ((List)trades.get(4)).add(ModEvents.createBuyTrade(() -> Items.f_42616_, 4, () -> new ItemStack((ItemLike)ModEvents.getCurrency("fifty_unit_note"), 8), 12, 20, 0.05f));
            ((List)trades.get(4)).add(ModEvents.createBuyTrade(() -> Items.f_42415_, 2, () -> new ItemStack((ItemLike)ModEvents.getCurrency("fifty_unit_note"), 10), 12, 25, 0.05f));
            ((List)trades.get(4)).add(new SellRandomItemFromListTrade(() -> new ItemStack((ItemLike)ModEvents.getCurrency("two_hundred_unit_note"), 10), (List<Supplier<Item>>)mobHeadsList, 1, 1, 30, 0.05f));
            ((List)trades.get(5)).add(ModEvents.createBuyTrade(() -> Items.f_42418_, 1, () -> new ItemStack((ItemLike)ModEvents.getCurrency("two_hundred_unit_note"), 10), 5, 30, 0.05f));
            ((List)trades.get(5)).add(ModEvents.createBuyTrade(() -> Items.f_42686_, 1, () -> new ItemStack((ItemLike)ModEvents.getCurrency("two_hundred_unit_note"), 20), 3, 50, 0.05f));
            ((List)trades.get(5)).add(ModEvents.createSellTrade(() -> new ItemStack((ItemLike)ModEvents.getCurrency("one_hundred_unit_note"), 25), () -> new ItemStack((ItemLike)Items.f_42437_), 1, 30, 0.05f));
            ((List)trades.get(5)).add(ModEvents.createSellTrade(() -> new ItemStack((ItemLike)ModEvents.getCurrency("two_hundred_unit_note"), 25), () -> new ItemStack((ItemLike)Items.f_42747_), 1, 30, 0.05f));
        }
    }

    private static Item getCurrency(String name) {
        return (Item)CurrencyCraft.CURRENCYCRAFT_ITEMS.get(name).get();
    }

    private static VillagerTrades.ItemListing createBuyTrade(Supplier<ItemLike> itemToBuy, int count, Supplier<ItemStack> currencyToGive, int maxUses, int xp, float priceMultiplier) {
        return (pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)itemToBuy.get(), count), (ItemStack)currencyToGive.get(), maxUses, xp, priceMultiplier);
    }

    private static VillagerTrades.ItemListing createSellTrade(Supplier<ItemStack> currencyToTake, Supplier<ItemStack> itemToSell, int maxUses, int xp, float priceMultiplier) {
        return (pTrader, pRandom) -> new MerchantOffer((ItemStack)currencyToTake.get(), (ItemStack)itemToSell.get(), maxUses, xp, priceMultiplier);
    }

    private static class BuyRandomItemFromTagTrade
    implements VillagerTrades.ItemListing {
        private final TagKey<Item> itemTag;
        private final int inputCount;
        private final Supplier<ItemStack> outputStackSupplier;
        private final int maxUses;
        private final int xp;
        private final float priceMultiplier;

        public BuyRandomItemFromTagTrade(TagKey<Item> itemTag, int inputCount, Supplier<ItemStack> outputStackSupplier, int maxUses, int xp, float priceMultiplier) {
            this.itemTag = itemTag;
            this.inputCount = inputCount;
            this.outputStackSupplier = outputStackSupplier;
            this.maxUses = maxUses;
            this.xp = xp;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer m_213663_(Entity pTrader, RandomSource pRandom) {
            Optional<List> itemsInTag = BuiltInRegistries.f_257033_.m_203431_(this.itemTag).map(tag -> tag.m_203614_().map(holder -> (Item)holder.m_203334_()).toList());
            if (itemsInTag.isPresent() && !itemsInTag.get().isEmpty()) {
                List items = itemsInTag.get();
                Item randomItem = (Item)items.get(pRandom.m_188503_(items.size()));
                ItemStack inputStack = new ItemStack((ItemLike)randomItem, this.inputCount);
                return new MerchantOffer(inputStack, this.outputStackSupplier.get(), this.maxUses, this.xp, this.priceMultiplier);
            }
            return null;
        }
    }

    private static class SellRandomItemFromTagTrade
    implements VillagerTrades.ItemListing {
        private final Supplier<ItemStack> priceSupplier;
        private final TagKey<Item> resultItemTag;
        private final int resultCount;
        private final int maxUses;
        private final int xp;
        private final float priceMultiplier;

        public SellRandomItemFromTagTrade(Supplier<ItemStack> priceSupplier, TagKey<Item> resultItemTag, int resultCount, int maxUses, int xp, float priceMultiplier) {
            this.priceSupplier = priceSupplier;
            this.resultItemTag = resultItemTag;
            this.resultCount = resultCount;
            this.maxUses = maxUses;
            this.xp = xp;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer m_213663_(Entity pTrader, RandomSource pRandom) {
            Optional<List> itemsInTag = BuiltInRegistries.f_257033_.m_203431_(this.resultItemTag).map(tag -> tag.m_203614_().map(holder -> (Item)holder.m_203334_()).toList());
            if (itemsInTag.isPresent() && !itemsInTag.get().isEmpty()) {
                List items = itemsInTag.get();
                Item randomItem = (Item)items.get(pRandom.m_188503_(items.size()));
                ItemStack resultStack = new ItemStack((ItemLike)randomItem, this.resultCount);
                return new MerchantOffer(this.priceSupplier.get(), resultStack, this.maxUses, this.xp, this.priceMultiplier);
            }
            return null;
        }
    }

    private static class SellRandomItemFromListTrade
    implements VillagerTrades.ItemListing {
        private final Supplier<ItemStack> priceSupplier;
        private final List<Supplier<Item>> resultItemSuppliers;
        private final int resultCount;
        private final int maxUses;
        private final int xp;
        private final float priceMultiplier;

        public SellRandomItemFromListTrade(Supplier<ItemStack> priceSupplier, List<Supplier<Item>> resultItemSuppliers, int resultCount, int maxUses, int xp, float priceMultiplier) {
            this.priceSupplier = priceSupplier;
            this.resultItemSuppliers = resultItemSuppliers;
            this.resultCount = resultCount;
            this.maxUses = maxUses;
            this.xp = xp;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer m_213663_(Entity pTrader, RandomSource pRandom) {
            if (!this.resultItemSuppliers.isEmpty()) {
                Supplier<Item> randomItemSupplier = this.resultItemSuppliers.get(pRandom.m_188503_(this.resultItemSuppliers.size()));
                ItemStack resultStack = new ItemStack((ItemLike)randomItemSupplier.get(), this.resultCount);
                return new MerchantOffer(this.priceSupplier.get(), resultStack, this.maxUses, this.xp, this.priceMultiplier);
            }
            return null;
        }
    }
}

