/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.gui.ATM;

import cc.spea.currencycraft.CurrencyCraft;
import cc.spea.currencycraft.bank.BankAccountData;
import cc.spea.currencycraft.bank.BankAccountManager;
import cc.spea.currencycraft.items.DebitCardItem;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ATMMainMenu
extends AbstractContainerMenu {
    private final Container depositSlot;
    private final ContainerData balanceData;
    private final Player player;
    public static final int DEPOSIT_SLOT_INDEX = 0;

    public ATMMainMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, (Container)new SimpleContainer(1), (ContainerData)new SimpleContainerData(4));
    }

    public ATMMainMenu(int windowId, Inventory playerInventory, Container depositSlot, ContainerData balanceData) {
        super((MenuType)CurrencyCraft.ATM_MAIN_MENU.get(), windowId);
        Player player;
        this.depositSlot = depositSlot;
        this.balanceData = balanceData;
        this.player = playerInventory.f_35978_;
        ATMMainMenu.m_38869_((Container)depositSlot, (int)1);
        this.m_38884_(balanceData);
        this.m_38897_(new Slot(depositSlot, 0, 62, 20){

            public boolean m_5857_(ItemStack stack) {
                return CurrencyCraft.CURRENCY_VALUES.containsKey(stack.m_41720_());
            }
        });
        int slotSize = 18;
        int playerInvXOffset = 8;
        int playerInvYOffset = 84;
        int playerHotbarYOffset = 142;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = 84 + row * 18;
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, x, y));
            }
        }
        for (int i = 0; i < 9; ++i) {
            int x = 8 + i * 18;
            this.m_38897_(new Slot((Container)playerInventory, i, x, 142));
        }
        if (!playerInventory.f_35978_.m_9236_().f_46443_ && (player = playerInventory.f_35978_) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.updateBalance();
        }
    }

    public void updateBalance() {
        Player player;
        if (!this.player.m_9236_().f_46443_ && (player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack cardStack = this.player.m_21205_();
            if (DebitCardItem.isValidCard(cardStack)) {
                BankAccountManager manager;
                BankAccountData account;
                UUID cardId = DebitCardItem.getCardId(cardStack);
                String pin = DebitCardItem.getPin(cardStack);
                UUID ownerUuid = DebitCardItem.getOwnerUuid(cardStack);
                if (ownerUuid == null) {
                    ownerUuid = this.player.m_20148_();
                }
                if ((account = (manager = BankAccountManager.get(serverPlayer.f_8924_)).getAccount(ownerUuid)).isCardValid(cardId, pin)) {
                    long balance = account.getBalance();
                    this.balanceData.m_8050_(0, (int)(balance >> 48 & 0xFFFFL));
                    this.balanceData.m_8050_(1, (int)(balance >> 32 & 0xFFFFL));
                    this.balanceData.m_8050_(2, (int)(balance >> 16 & 0xFFFFL));
                    this.balanceData.m_8050_(3, (int)(balance & 0xFFFFL));
                }
            }
        }
    }

    public long getBalance() {
        long short3 = (long)this.balanceData.m_6413_(0) & 0xFFFFL;
        long short2 = (long)this.balanceData.m_6413_(1) & 0xFFFFL;
        long short1 = (long)this.balanceData.m_6413_(2) & 0xFFFFL;
        long short0 = (long)this.balanceData.m_6413_(3) & 0xFFFFL;
        return short3 << 48 | short2 << 32 | short1 << 16 | short0;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public void m_6877_(Player player) {
        ItemStack stack;
        super.m_6877_(player);
        if (!player.m_9236_().f_46443_ && !(stack = this.depositSlot.m_8016_(0)).m_41619_()) {
            player.m_150109_().m_150079_(stack);
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(slotStack, 1, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else if (CurrencyCraft.CURRENCY_VALUES.containsKey(slotStack.m_41720_())) {
                if (!this.m_38903_(slotStack, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }
}

