/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.gui.ATM;

import cc.spea.currencycraft.gui.ATM.ATMMainMenu;
import cc.spea.currencycraft.network.ModMessages;
import cc.spea.currencycraft.network.packets.C2SATMDeposit;
import cc.spea.currencycraft.network.packets.C2SATMWithdraw;
import com.mojang.blaze3d.systems.RenderSystem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ATMMainScreen
extends AbstractContainerScreen<ATMMainMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"currencycraft", (String)"textures/gui/atm_main.png");
    private EditBox withdrawalInput;
    private Button depositButton;
    private Button withdrawButton;

    public ATMMainScreen(ATMMainMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.withdrawalInput = new EditBox(this.f_96547_, x + 10, y + 54, 80, 15, (Component)Component.m_237115_((String)"text.currencycraft.atm.amount"));
        this.withdrawalInput.m_94199_(10);
        this.withdrawalInput.m_94153_(s -> s.matches("\\d*\\.?\\d{0,2}"));
        this.m_142416_((GuiEventListener)this.withdrawalInput);
        this.depositButton = Button.m_253074_((Component)Component.m_237115_((String)"text.currencycraft.atm.deposit"), button -> this.onDeposit()).m_252987_(x + 95, y + 18, 70, 15).m_253136_();
        this.m_142416_((GuiEventListener)this.depositButton);
        this.withdrawButton = Button.m_253074_((Component)Component.m_237115_((String)"text.currencycraft.atm.withdraw"), button -> this.onWithdraw()).m_252987_(x + 95, y + 53, 70, 15).m_253136_();
        this.m_142416_((GuiEventListener)this.withdrawButton);
    }

    private void onDeposit() {
        ModMessages.sendToServer(new C2SATMDeposit(0));
    }

    private void onWithdraw() {
        try {
            BigDecimal amountBd;
            long amountCents;
            String amountStr = this.withdrawalInput.m_94155_();
            if (!amountStr.isEmpty() && (amountCents = (amountBd = new BigDecimal(amountStr).setScale(2, RoundingMode.HALF_UP)).multiply(BigDecimal.valueOf(100L)).longValue()) > 0L) {
                ModMessages.sendToServer(new C2SATMWithdraw(amountCents));
                this.withdrawalInput.m_94144_("");
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void m_7286_(GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        gui.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_280003_(GuiGraphics gui, int mouseX, int mouseY) {
        gui.m_280614_(this.f_96547_, this.f_96539_, 8, 6, 0x404040, false);
        long balance = ((ATMMainMenu)this.f_97732_).getBalance();
        String balanceStr = String.format("Balance: $%.2f", (double)balance / 100.0);
        gui.m_280056_(this.f_96547_, balanceStr, 10, 41, 43520, false);
        gui.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"text.currencycraft.atm.deposit_slot"), 10, 18, 0x404040, false);
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gui);
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.m_280072_(gui, mouseX, mouseY);
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String withdrawValue = this.withdrawalInput.m_94155_();
        super.m_6574_(minecraft, width, height);
        this.withdrawalInput.m_94144_(withdrawValue);
    }
}

