/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.gui.CashRegister;

import cc.spea.currencycraft.CurrencyCraft;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;

public final class CashRegisterLayout {
    private static final List<String> NOTE_NAMES = List.of("five_unit_note", "ten_unit_note", "twenty_unit_note", "fifty_unit_note", "one_hundred_unit_note", "two_hundred_unit_note", "five_hundred_unit_note");
    private static final List<String> COIN_NAMES = List.of("one_cent_coin", "two_cent_coin", "five_cent_coin", "ten_cent_coin", "twenty_cent_coin", "fifty_cent_coin", "one_unit_coin", "two_unit_coin");
    private static final Map<Integer, RegistryObject<Item>> VALID_ITEMS_MAP = IntStream.range(0, 30).boxed().collect(Collectors.toMap(index -> index, CashRegisterLayout::determineValidItemForSlot));

    @Nullable
    public static RegistryObject<Item> getValidItemForSlot(int slotIndex) {
        return VALID_ITEMS_MAP.get(slotIndex);
    }

    @Nullable
    public static ResourceLocation getPlaceholderTextureForSlot(int slotIndex) {
        RegistryObject<Item> validItem = CashRegisterLayout.getValidItemForSlot(slotIndex);
        if (validItem != null) {
            String name = validItem.getId().m_135815_();
            return ResourceLocation.fromNamespaceAndPath((String)"currencycraft", (String)("textures/gui/sprites/container/slots/" + name + ".png"));
        }
        return null;
    }

    @Nullable
    private static RegistryObject<Item> determineValidItemForSlot(int index) {
        int relativeIndex;
        int col;
        int coinNameIndex;
        int col2;
        int noteNameIndex;
        if (index >= 0 && index < 14 && (noteNameIndex = 6 - (col2 = index % 7)) < NOTE_NAMES.size()) {
            return CurrencyCraft.CURRENCY_ITEMS.get(NOTE_NAMES.get(noteNameIndex));
        }
        if (index >= 14 && index < 30 && (coinNameIndex = 7 - (col = (relativeIndex = index - 14) % 8)) < COIN_NAMES.size()) {
            return CurrencyCraft.CURRENCY_ITEMS.get(COIN_NAMES.get(coinNameIndex));
        }
        return null;
    }
}

