/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.gui.CashRegister;

import cc.spea.currencycraft.CurrencyCraft;
import cc.spea.currencycraft.blocks.CashRegister.CashRegisterBlockEntity;
import cc.spea.currencycraft.gui.CashRegister.CashRegisterLayout;
import cc.spea.currencycraft.gui.CashRegister.PlaceholderSlot;
import cc.spea.currencycraft.sounds.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;

public class CashRegisterMenu
extends AbstractContainerMenu {
    private final Container container;
    private final ContainerData data;
    private final BlockPos pos;

    public CashRegisterMenu(int windowId, Inventory playerInv, Container container, ContainerData data) {
        super((MenuType)CurrencyCraft.CASH_REGISTER_MENU.get(), windowId);
        int col;
        int row;
        this.container = container;
        CashRegisterMenu.m_38869_((Container)container, (int)30);
        this.data = data;
        if (container instanceof CashRegisterBlockEntity) {
            CashRegisterBlockEntity be = (CashRegisterBlockEntity)container;
            this.pos = be.m_58899_();
        } else {
            this.pos = BlockPos.f_121853_;
        }
        int slotIndex = 0;
        int X_START = 8;
        int Y_START = 30;
        int SLOT_SPACING = 18;
        for (row = 0; row < 2; ++row) {
            for (col = 0; col < 7; ++col) {
                this.addCustomSlot(container, slotIndex, 8 + col * 18, 30 + row * 18);
                ++slotIndex;
            }
        }
        for (row = 0; row < 2; ++row) {
            for (col = 0; col < 8; ++col) {
                this.addCustomSlot(container, slotIndex, 8 + col * 18, 30 + (row + 2) * 18);
                ++slotIndex;
            }
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.m_38897_(new Slot((Container)playerInv, j1 + l * 9 + 9, 8 + j1 * 18, 116 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.m_38897_(new Slot((Container)playerInv, i1, 8 + i1 * 18, 174));
        }
    }

    private void addCustomSlot(Container container, int index, int x, int y) {
        RegistryObject<Item> validItem = CashRegisterLayout.getValidItemForSlot(index);
        ResourceLocation placeholder = CashRegisterLayout.getPlaceholderTextureForSlot(index);
        PlaceholderSlot slot = new PlaceholderSlot(container, index, x, y, placeholder, validItem){

            public void m_6654_() {
                Container container;
                super.m_6654_();
                if (this.m_6657_() && (container = this.f_40218_) instanceof CashRegisterBlockEntity) {
                    CashRegisterBlockEntity be = (CashRegisterBlockEntity)container;
                    if (!be.m_58904_().f_46443_) {
                        if (this.getSlotIndex() < 14) {
                            be.m_58904_().m_5594_(null, CashRegisterMenu.this.pos, (SoundEvent)ModSounds.CASH_REGISTER_NOTE.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
                        } else {
                            be.m_58904_().m_5594_(null, CashRegisterMenu.this.pos, (SoundEvent)ModSounds.CASH_REGISTER_COIN.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
                        }
                    }
                }
            }
        };
        this.m_38897_(slot);
    }

    public Container getContainer() {
        return this.container;
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public ItemStack m_7648_(Player p_40199_, int p_40200_) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(p_40200_);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (p_40200_ < this.container.m_6643_() ? !this.m_38903_(itemstack1, this.container.m_6643_(), this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.container.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public long getTotalValueInCents() {
        int upper = this.data.m_6413_(0);
        int lower = this.data.m_6413_(1);
        return (long)upper << 32 | (long)lower & 0xFFFFFFFFL;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!player.m_9236_().f_46443_) {
            player.m_9236_().m_5594_(null, this.pos, (SoundEvent)ModSounds.CASH_REGISTER_CLOSE.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
        }
    }
}

