/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.gui.VendingMachine;

import cc.spea.currencycraft.blocks.VendingMachine.VendingMachineBlockEntity;
import cc.spea.currencycraft.gui.VendingMachine.VendingMachinePurchaseMenu;
import cc.spea.currencycraft.network.ModMessages;
import cc.spea.currencycraft.network.packets.C2SPurchaseVendingMachineItem;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class VendingMachinePurchaseScreen
extends AbstractContainerScreen<VendingMachinePurchaseMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"currencycraft", (String)"textures/gui/vending_machine_purchase.png");
    private Button[] priceButtons;
    private final VendingMachineBlockEntity blockEntity;

    public VendingMachinePurchaseScreen(VendingMachinePurchaseMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.f_97726_ = 122;
        this.f_97727_ = 108;
        this.blockEntity = menu.getBlockEntity();
        this.priceButtons = new Button[menu.getBlockEntity().getProductSlots()];
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonGridX = this.f_97735_ + 34;
        int buttonGridY = this.f_97736_ + 29;
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 3; ++col) {
                Button priceButton;
                int slotIndex = row * 3 + col;
                int x = buttonGridX + col * 18;
                int y = buttonGridY + row * 18;
                long priceInCents = this.blockEntity.getPriceInCents(slotIndex);
                Tooltip priceTooltip = this.generateTooltip(priceInCents, slotIndex);
                this.priceButtons[slotIndex] = priceButton = Button.m_253074_((Component)Component.m_237119_(), button -> this.selectSlotForPurchase(slotIndex, false)).m_252987_(x + 1, y + 1, 16, 16).m_257505_(priceTooltip).m_253136_();
                this.m_142416_((GuiEventListener)priceButton);
            }
        }
    }

    private void selectSlotForPurchase(int slotIndex, boolean buyAll) {
        if (this.blockEntity.getPriceInCents(slotIndex) <= this.blockEntity.calculateTotalCurrencyValueInCents()) {
            ModMessages.sendToServer(new C2SPurchaseVendingMachineItem(this.blockEntity.m_58899_(), slotIndex, buyAll));
            return;
        }
        this.blockEntity.m_58904_().m_245747_(this.blockEntity.m_58899_(), SoundEvents.f_12055_, SoundSource.BLOCKS, 1.0f, 1.0f, true);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean shiftHeld = VendingMachinePurchaseScreen.m_96638_();
        for (int i = 0; i < this.priceButtons.length; ++i) {
            if (this.priceButtons[i] == null || !this.priceButtons[i].m_5953_(mouseX, mouseY)) continue;
            int slotIndex = i;
            if (shiftHeld) {
                this.selectSlotForPurchase(slotIndex, true);
                return true;
            }
            this.selectSlotForPurchase(slotIndex, false);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderProductItems(guiGraphics);
        for (int i = 0; i < this.blockEntity.getProductSlots(); ++i) {
            if (this.blockEntity.getPriceInCents(i) <= this.blockEntity.calculateTotalCurrencyValueInCents()) continue;
            int row = i / 3;
            int col = i % 3;
            int slotX = this.f_97735_ + 36 + col * 18;
            int slotY = this.f_97736_ + 31 + row * 18;
            guiGraphics.m_280509_(slotX, slotY, slotX + 14, slotY + 14, -2130771968);
        }
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    private void renderProductItems(GuiGraphics guiGraphics) {
        int buttonGridX = this.f_97735_ + 34;
        int buttonGridY = this.f_97736_ + 29;
        for (int i = 0; i < this.blockEntity.getProductSlots(); ++i) {
            ItemStack productStack = this.blockEntity.m_8020_(i);
            if (productStack.m_41619_()) continue;
            int row = i / 3;
            int col = i % 3;
            int x = buttonGridX + col * 18;
            int y = buttonGridY + row * 18;
            guiGraphics.m_280203_(productStack, x + 1, y + 1);
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        MutableComponent insertedMoneyComponent = Component.m_237110_((String)"gui.currencycraft.vending_machine.total", (Object[])new Object[]{String.format("%.2f", Float.valueOf((float)((VendingMachinePurchaseMenu)this.f_97732_).getBlockEntity().calculateTotalCurrencyValueInCents() / 100.0f))});
        int textWidth = this.f_96547_.m_92852_((FormattedText)insertedMoneyComponent);
        int centeredX = this.f_97726_ / 2 - textWidth / 2;
        int y = this.f_97729_ + 12;
        graphics.m_280614_(this.f_96547_, (Component)insertedMoneyComponent, centeredX, y, 0x404040, false);
    }

    private Tooltip generateTooltip(long priceInCents, int slotIndex) {
        int canAfford;
        int maxPurchasable;
        double priceInUnits = (float)priceInCents / 100.0f;
        MutableComponent priceText = Component.m_237113_((String)String.format("%.2f", priceInUnits));
        long insertedValue = this.blockEntity.calculateTotalCurrencyValueInCents();
        ItemStack itemStack = this.blockEntity.m_8020_(slotIndex);
        int available = itemStack.m_41613_();
        if (priceInCents > 0L && available > 0 && (maxPurchasable = Math.min(canAfford = (int)(insertedValue / priceInCents), available)) > 1) {
            MutableComponent tooltipText = Component.m_237119_().m_7220_((Component)priceText).m_130946_("\n").m_7220_((Component)Component.m_237110_((String)"tooltip.currencycraft.vending_machine.available", (Object[])new Object[]{available}).m_130940_(ChatFormatting.GRAY)).m_130946_("\n").m_7220_((Component)Component.m_237110_((String)"tooltip.currencycraft.vending_machine.shift_buy", (Object[])new Object[]{maxPurchasable}).m_130940_(ChatFormatting.YELLOW));
            return Tooltip.m_257550_((Component)tooltipText);
        }
        return Tooltip.m_257550_((Component)priceText);
    }
}

