/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.gui.VendingMachine;

import cc.spea.currencycraft.blocks.VendingMachine.VendingMachineBlockEntity;
import cc.spea.currencycraft.gui.VendingMachine.VendingMachineRestockMenu;
import cc.spea.currencycraft.network.ModMessages;
import cc.spea.currencycraft.network.packets.C2SSetVendingPricePacket;
import com.mojang.blaze3d.systems.RenderSystem;
import java.math.BigDecimal;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class VendingMachineRestockScreen
extends AbstractContainerScreen<VendingMachineRestockMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"currencycraft", (String)"textures/gui/vending_machine.png");
    private EditBox priceField;
    private Button saveButton;
    private int selectedSlot = -1;
    private int hoveredSlot = -1;
    private Button[] priceButtons;
    private final VendingMachineBlockEntity blockEntity;

    public VendingMachineRestockScreen(VendingMachineRestockMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.f_97726_ = 230;
        this.f_97727_ = 216;
        this.f_97731_ = this.f_97727_ - 94;
        this.blockEntity = menu.getBlockEntity();
        this.priceButtons = new Button[menu.getBlockEntity().getProductSlots()];
    }

    protected void m_7856_() {
        super.m_7856_();
        int priceFieldX = this.f_97735_ + 8;
        int priceFieldY = this.f_97736_ + 106;
        this.priceField = new EditBox(this.f_96547_, priceFieldX, priceFieldY, 52, 12, (Component)Component.m_237115_((String)"gui.currencycraft.price"));
        this.priceField.m_94194_(false);
        this.m_142416_((GuiEventListener)this.priceField);
        this.saveButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.currencycraft.vending_machine.save"), button -> this.savePrice()).m_252987_(priceFieldX + 55, priceFieldY - 1, 40, 14).m_253136_();
        this.saveButton.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.saveButton);
        int buttonGridX = this.f_97735_ + 7;
        int buttonGridY = this.f_97736_ + 29;
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 3; ++col) {
                Button priceButton;
                int slotIndex = row * 3 + col;
                int x = buttonGridX + col * 18;
                int y = buttonGridY + row * 18;
                long priceInCents = this.blockEntity.getPriceInCents(slotIndex);
                Tooltip priceTooltip = this.generateTooltip(priceInCents);
                this.priceButtons[slotIndex] = priceButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.currencycraft.vending_machine.price_button"), button -> this.selectSlotForPricing(slotIndex)).m_252987_(x + 1, y + 1, 16, 16).m_257505_(priceTooltip).m_253136_();
                this.m_142416_((GuiEventListener)priceButton);
            }
        }
    }

    private void selectSlotForPricing(int slotIndex) {
        this.selectedSlot = slotIndex;
        this.priceField.m_94194_(true);
        this.saveButton.f_93624_ = true;
        long currentPrice = this.blockEntity.getPriceInCents(slotIndex);
        if (currentPrice > 0L) {
            BigDecimal priceDecimal = BigDecimal.valueOf(currentPrice).divide(new BigDecimal("100"));
            this.priceField.m_94144_(priceDecimal.toPlainString());
        } else {
            this.priceField.m_94144_("");
        }
        this.priceField.m_94202_(0xE0E0E0);
        this.m_7522_((GuiEventListener)this.priceField);
    }

    private void savePrice() {
        long priceInCents;
        if (this.selectedSlot == -1) {
            return;
        }
        String text = this.priceField.m_94155_();
        try {
            if (text.trim().isEmpty()) {
                priceInCents = 0L;
            } else {
                BigDecimal priceDecimal = new BigDecimal(text);
                if (priceDecimal.signum() < 0) {
                    throw new NumberFormatException("Price cannot be negative.");
                }
                if (priceDecimal.scale() > 2) {
                    throw new NumberFormatException("Price has too many decimal places.");
                }
                priceInCents = priceDecimal.multiply(new BigDecimal("100")).longValueExact();
            }
        }
        catch (ArithmeticException | NumberFormatException e) {
            this.priceField.m_94202_(-43691);
            return;
        }
        ModMessages.sendToServer(new C2SSetVendingPricePacket(this.blockEntity.m_58899_(), this.selectedSlot, priceInCents));
        this.priceButtons[this.selectedSlot].m_257544_(this.generateTooltip(priceInCents));
        this.hidePriceEditor();
    }

    private void hidePriceEditor() {
        this.selectedSlot = -1;
        this.priceField.m_94194_(false);
        this.saveButton.f_93624_ = false;
        this.priceField.m_93692_(false);
        this.m_7522_(null);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (super.m_6375_(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if (this.priceField.m_93696_()) {
            this.hidePriceEditor();
            return true;
        }
        return false;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int slotY;
        int slotX;
        int col;
        int row;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (this.selectedSlot != -1) {
            row = this.selectedSlot / 3;
            col = this.selectedSlot % 3;
            slotX = this.f_97735_ + 71 + col * 18;
            slotY = this.f_97736_ + 30 + row * 18;
            guiGraphics.m_280509_(slotX, slotY, slotX + 16, slotY + 16, -2130706433);
        }
        if (this.hoveredSlot != -1 && this.selectedSlot != this.hoveredSlot) {
            row = this.hoveredSlot / 3;
            col = this.hoveredSlot % 3;
            slotX = this.f_97735_ + 71 + col * 18;
            slotY = this.f_97736_ + 30 + row * 18;
            guiGraphics.m_280509_(slotX, slotY, slotX + 16, slotY + 16, -2130706433);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        this.hoveredSlot = -1;
        for (int i = 0; i < this.priceButtons.length; ++i) {
            if (!this.priceButtons[i].m_274382_()) continue;
            this.hoveredSlot = i;
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.priceField.m_93696_()) {
            if (keyCode == 257 || keyCode == 335) {
                this.savePrice();
                return true;
            }
            if (keyCode == 256) {
                this.hidePriceEditor();
                return true;
            }
            this.priceField.m_94202_(0xE0E0E0);
            return this.priceField.m_7933_(keyCode, scanCode, modifiers);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        graphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
        this.drawStrings(graphics);
    }

    private void drawStrings(GuiGraphics graphics) {
        MutableComponent pricesComponent = Component.m_237115_((String)"gui.currencycraft.vending_machine.prices");
        MutableComponent productComponent = Component.m_237115_((String)"gui.currencycraft.vending_machine.product");
        MutableComponent profitComponent = Component.m_237115_((String)"gui.currencycraft.vending_machine.profit");
        int x = this.f_97728_;
        int y = this.f_97729_ + 12;
        graphics.m_280614_(this.f_96547_, (Component)pricesComponent, x, y, 0x404040, false);
        graphics.m_280614_(this.f_96547_, (Component)productComponent, x + 63, y, 0x404040, false);
        graphics.m_280614_(this.f_96547_, (Component)profitComponent, x + 126, y, 0x404040, false);
    }

    private Tooltip generateTooltip(long priceInCents) {
        double priceInUnits = (float)priceInCents / 100.0f;
        return priceInUnits == 0.0 ? Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.currencycraft.vending_machine.edit").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC})) : Tooltip.m_257550_((Component)Component.m_237113_((String)String.format("%.2f", priceInUnits)).m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"gui.currencycraft.vending_machine.edit").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC})));
    }
}

