/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.helper;

import cc.spea.currencycraft.CurrencyCraft;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ModHelpers {
    public static long calculateTotalCurrencyValueInCents(List<ItemStack> items) {
        long totalValue = 0L;
        for (ItemStack stack : items) {
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            long itemValue = CurrencyCraft.CURRENCY_VALUES.getOrDefault(item, 0L);
            totalValue += itemValue * (long)stack.m_41613_();
        }
        return totalValue;
    }

    public static NonNullList<ItemStack> calculateItemStacksFromCents(long totalValue) {
        int dpLimit;
        NonNullList result = NonNullList.m_122779_();
        if (totalValue <= 0L) {
            return result;
        }
        List<Map.Entry<Item, Long>> sortedCurrencies = CurrencyCraft.CURRENCY_VALUES.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toList());
        sortedCurrencies.removeIf(entry -> (Long)entry.getValue() <= 0L);
        if (sortedCurrencies.isEmpty()) {
            return result;
        }
        long remainingValue = totalValue;
        Map.Entry largestDenom = (Map.Entry)sortedCurrencies.get(0);
        long largestValue = (Long)largestDenom.getValue();
        if (remainingValue > largestValue * 64L * 100L) {
            long bulkCount = remainingValue / largestValue;
            long bulkValue = bulkCount * largestValue;
            int fullStacks = (int)(bulkCount / 64L);
            int remainder = (int)(bulkCount % 64L);
            for (int i = 0; i < fullStacks; ++i) {
                result.add((Object)new ItemStack((ItemLike)largestDenom.getKey(), 64));
            }
            if (remainder > 0) {
                result.add((Object)new ItemStack((ItemLike)largestDenom.getKey(), remainder));
            }
            if ((remainingValue -= bulkValue) == 0L) {
                return result;
            }
        }
        if (remainingValue > (long)(dpLimit = Math.min((int)remainingValue, 100000))) {
            result.addAll(ModHelpers.greedyChange(remainingValue, sortedCurrencies));
        } else {
            result.addAll(ModHelpers.optimalChange((int)remainingValue, sortedCurrencies));
        }
        return result;
    }

    private static NonNullList<ItemStack> optimalChange(int value, List<Map.Entry<Item, Long>> sortedCurrencies) {
        int currentValue;
        int itemCount;
        Map.Entry<Item, Long> entry;
        int[] dp = new int[value + 1];
        int[] parent = new int[value + 1];
        int[] count = new int[value + 1];
        for (int i = 1; i <= value; ++i) {
            dp[i] = Integer.MAX_VALUE;
        }
        dp[0] = 0;
        for (int currentValue2 = 0; currentValue2 < value; ++currentValue2) {
            if (dp[currentValue2] == Integer.MAX_VALUE) continue;
            for (int denomIdx = 0; denomIdx < sortedCurrencies.size(); ++denomIdx) {
                long nextValue;
                long denomValue = sortedCurrencies.get(denomIdx).getValue();
                if (denomValue > Integer.MAX_VALUE) continue;
                int denom = (int)denomValue;
                for (int itemCount2 = 1; itemCount2 <= 64 && (nextValue = (long)currentValue2 + (long)denom * (long)itemCount2) <= (long)value; ++itemCount2) {
                    int stacksNeeded = dp[currentValue2] + 1;
                    if (stacksNeeded >= dp[(int)nextValue]) continue;
                    dp[(int)nextValue] = stacksNeeded;
                    parent[(int)nextValue] = denomIdx;
                    count[(int)nextValue] = itemCount2;
                }
            }
        }
        NonNullList result = NonNullList.m_122779_();
        for (currentValue = value; currentValue > 0 && dp[currentValue] != Integer.MAX_VALUE; currentValue -= (int)(entry.getValue() * (long)itemCount)) {
            int denomIdx = parent[currentValue];
            itemCount = count[currentValue];
            entry = sortedCurrencies.get(denomIdx);
            result.add((Object)new ItemStack((ItemLike)entry.getKey(), itemCount));
        }
        if (currentValue > 0 || dp[value] == Integer.MAX_VALUE) {
            return ModHelpers.greedyChange(value, sortedCurrencies);
        }
        return result;
    }

    private static NonNullList<ItemStack> greedyChange(long totalValue, List<Map.Entry<Item, Long>> sortedCurrencies) {
        NonNullList result = NonNullList.m_122779_();
        for (Map.Entry<Item, Long> entry : sortedCurrencies) {
            Item item = entry.getKey();
            long itemValue = entry.getValue();
            if (itemValue <= 0L || totalValue < itemValue) continue;
            long count = totalValue / itemValue;
            if (count > 0L) {
                int fullStacks = (int)(count / 64L);
                int remainder = (int)(count % 64L);
                for (int i = 0; i < fullStacks; ++i) {
                    result.add((Object)new ItemStack((ItemLike)item, 64));
                }
                if (remainder > 0) {
                    result.add((Object)new ItemStack((ItemLike)item, remainder));
                }
            }
            if ((totalValue %= itemValue) != 0L) continue;
            break;
        }
        return result;
    }
}

