/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.items;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class DebitCardItem
extends Item {
    private static final String CARD_ID_KEY = "CardId";
    private static final String PIN_KEY = "Pin";
    private static final String CANCELLED_KEY = "Cancelled";
    private static final String OWNER_UUID_KEY = "OwnerUUID";
    private static final String OWNER_NAME_KEY = "OwnerName";

    public DebitCardItem(Item.Properties properties) {
        super(properties);
    }

    public static void setCardId(ItemStack stack, UUID cardId) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128362_(CARD_ID_KEY, cardId);
    }

    public static UUID getCardId(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128403_(CARD_ID_KEY)) {
            return tag.m_128342_(CARD_ID_KEY);
        }
        return null;
    }

    public static boolean hasCardId(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128403_(CARD_ID_KEY);
    }

    public static boolean isBlankCard(ItemStack stack) {
        return !DebitCardItem.hasCardId(stack) && !DebitCardItem.isCancelled(stack);
    }

    public static void setPin(ItemStack stack, String pin) {
        if (pin == null || pin.length() != 4 || !pin.matches("\\d{4}")) {
            throw new IllegalArgumentException("PIN must be a 4-digit string (0000-9999)");
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(PIN_KEY, pin);
    }

    public static String getPin(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(PIN_KEY)) {
            return tag.m_128461_(PIN_KEY);
        }
        return null;
    }

    public static boolean hasPin(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_(PIN_KEY);
    }

    public static void setCancelled(ItemStack stack, boolean cancelled) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_(CANCELLED_KEY, cancelled);
    }

    public static boolean isCancelled(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_(CANCELLED_KEY);
    }

    public static void setOwner(ItemStack stack, UUID ownerUuid, String ownerName) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128362_(OWNER_UUID_KEY, ownerUuid);
        tag.m_128359_(OWNER_NAME_KEY, ownerName);
    }

    public static UUID getOwnerUuid(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128403_(OWNER_UUID_KEY)) {
            return tag.m_128342_(OWNER_UUID_KEY);
        }
        return null;
    }

    public static String getOwnerName(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(OWNER_NAME_KEY)) {
            return tag.m_128461_(OWNER_NAME_KEY);
        }
        return null;
    }

    public static boolean hasOwner(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128403_(OWNER_UUID_KEY);
    }

    public static boolean isValidCard(ItemStack stack) {
        return DebitCardItem.hasCardId(stack) && DebitCardItem.hasPin(stack) && !DebitCardItem.isCancelled(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        String ownerName = DebitCardItem.getOwnerName(stack);
        if (ownerName != null) {
            tooltip.add((Component)Component.m_237110_((String)"text.currencycraft.debit_card.owner", (Object[])new Object[]{ownerName}));
        }
        if (DebitCardItem.isCancelled(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"text.currencycraft.debit_card.cancelled"));
        } else if (DebitCardItem.isBlankCard(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"text.currencycraft.debit_card.blank"));
        } else if (DebitCardItem.hasCardId(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"text.currencycraft.debit_card.active"));
        }
    }
}

