/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.items.Wallet;

import cc.spea.currencycraft.gui.Wallet.WalletMenu;
import cc.spea.currencycraft.helper.ModHelpers;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WalletItem
extends Item
implements DyeableLeatherItem {
    public WalletItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        final ItemStack walletStack = player.m_21120_(hand);
        if (!level.m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 0.8f, 1.0f);
            MenuProvider menuProvider = new MenuProvider(){

                @NotNull
                public Component m_5446_() {
                    return walletStack.m_41786_();
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory playerInventory, @NotNull Player player) {
                    return new WalletMenu(windowId, playerInventory, walletStack);
                }
            };
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)menuProvider, buffer -> buffer.m_130055_(walletStack));
        }
        return InteractionResultHolder.m_19090_((Object)walletStack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        long totalValue = this.getTotalValue(stack);
        if (totalValue == 0L) {
            return;
        }
        double total = (float)totalValue / 100.0f;
        String formattedValue = String.format("%.2f", total);
        tooltip.add((Component)Component.m_237110_((String)"tooltip.currencycraft.wallet.total", (Object[])new Object[]{formattedValue}));
    }

    private long getTotalValue(ItemStack walletStack) {
        CompoundTag tag = walletStack.m_41783_();
        if (tag == null || !tag.m_128425_("Inventory", 9)) {
            return 0L;
        }
        ListTag inventoryTag = tag.m_128437_("Inventory", 10);
        NonNullList itemStacks = NonNullList.m_122779_();
        for (int i = 0; i < inventoryTag.size(); ++i) {
            CompoundTag itemTag = inventoryTag.m_128728_(i);
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)itemTag);
            if (itemStack.m_41619_()) continue;
            itemStacks.add((Object)itemStack);
        }
        return ModHelpers.calculateTotalCurrencyValueInCents((List<ItemStack>)itemStacks);
    }
}

