/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.network.packets;

import cc.spea.currencycraft.bank.BankAccountData;
import cc.spea.currencycraft.bank.BankAccountManager;
import cc.spea.currencycraft.bank.BankConfig;
import cc.spea.currencycraft.gui.ATM.ATMMainMenu;
import cc.spea.currencycraft.helper.ModHelpers;
import cc.spea.currencycraft.items.DebitCardItem;
import java.util.Collections;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class C2SATMDeposit {
    private final int depositSlotIndex;

    public C2SATMDeposit(int depositSlotIndex) {
        this.depositSlotIndex = depositSlotIndex;
    }

    public C2SATMDeposit(FriendlyByteBuf buf) {
        this.depositSlotIndex = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.depositSlotIndex);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            BankAccountManager manager;
            BankAccountData account;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            AbstractContainerMenu patt1591$temp = player.f_36096_;
            if (!(patt1591$temp instanceof ATMMainMenu)) {
                return;
            }
            ATMMainMenu menu = (ATMMainMenu)patt1591$temp;
            ItemStack depositStack = menu.m_38853_(this.depositSlotIndex).m_7993_();
            if (depositStack.m_41619_()) {
                player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.no_deposit"), true);
                return;
            }
            long depositValue = ModHelpers.calculateTotalCurrencyValueInCents(Collections.singletonList(depositStack));
            if (depositValue <= 0L) {
                player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.invalid_deposit"), true);
                return;
            }
            if (!BankConfig.isValidDepositAmount(depositValue)) {
                player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.deposit_limit_exceeded"), true);
                return;
            }
            ItemStack cardStack = player.m_21205_();
            if (!DebitCardItem.isValidCard(cardStack)) {
                player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.invalid_card"), true);
                return;
            }
            UUID cardId = DebitCardItem.getCardId(cardStack);
            String pin = DebitCardItem.getPin(cardStack);
            UUID ownerUuid = DebitCardItem.getOwnerUuid(cardStack);
            if (ownerUuid == null) {
                ownerUuid = player.m_20148_();
            }
            if (!(account = (manager = BankAccountManager.get(player.f_8924_)).getAccount(ownerUuid)).isCardValid(cardId, pin)) {
                player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.card_not_authorized"), true);
                return;
            }
            long netDeposit = BankConfig.calculateDepositAmount(depositValue);
            if (netDeposit <= 0L) {
                player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.deposit_too_small"), true);
                return;
            }
            depositStack.m_41774_(depositStack.m_41613_());
            account.deposit(netDeposit);
            manager.markDirty();
            player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12013_, SoundSource.PLAYERS, 0.7f, 1.2f);
            player.m_5661_((Component)Component.m_237110_((String)"text.currencycraft.atm.deposit_success", (Object[])new Object[]{String.format("%.2f", (double)netDeposit / 100.0)}), true);
            menu.updateBalance();
        });
        return true;
    }
}

