/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.network.packets;

import cc.spea.currencycraft.Config;
import cc.spea.currencycraft.bank.BankAccountData;
import cc.spea.currencycraft.bank.BankAccountManager;
import cc.spea.currencycraft.bank.BankConfig;
import cc.spea.currencycraft.gui.ATM.ATMMainMenu;
import cc.spea.currencycraft.helper.ModHelpers;
import cc.spea.currencycraft.items.DebitCardItem;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class C2SATMWithdraw {
    private final long amount;

    public C2SATMWithdraw(long amount) {
        this.amount = amount;
    }

    public C2SATMWithdraw(FriendlyByteBuf buf) {
        this.amount = buf.readLong();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeLong(this.amount);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            AbstractContainerMenu patt5561$temp;
            BankAccountManager manager;
            BankAccountData account;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            if (!BankConfig.isValidWithdrawalAmount(this.amount)) {
                player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.invalid_withdrawal"), true);
                player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12507_, SoundSource.PLAYERS, 0.5f, 1.0f);
                return;
            }
            ItemStack cardStack = player.m_21205_();
            if (!DebitCardItem.isValidCard(cardStack)) {
                player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.invalid_card"), true);
                return;
            }
            UUID cardId = DebitCardItem.getCardId(cardStack);
            String pin = DebitCardItem.getPin(cardStack);
            UUID ownerUuid = DebitCardItem.getOwnerUuid(cardStack);
            if (ownerUuid == null) {
                ownerUuid = player.m_20148_();
            }
            if (!(account = (manager = BankAccountManager.get(player.f_8924_)).getAccount(ownerUuid)).isCardValid(cardId, pin)) {
                player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.card_not_authorized"), true);
                return;
            }
            long totalCost = BankConfig.calculateWithdrawalCost(this.amount);
            if (account.getBalance() < totalCost) {
                player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.insufficient_funds"), true);
                player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12507_, SoundSource.PLAYERS, 0.5f, 1.0f);
                return;
            }
            if (!account.withdraw(totalCost)) {
                player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.withdrawal_failed"), true);
                player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12507_, SoundSource.PLAYERS, 0.5f, 1.0f);
                return;
            }
            NonNullList<ItemStack> moneyStacks = ModHelpers.calculateItemStacksFromCents(this.amount);
            for (ItemStack stack : moneyStacks) {
                if (player.m_150109_().m_36054_(stack)) continue;
                ItemEntity itemEntity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
                player.m_9236_().m_7967_((Entity)itemEntity);
            }
            manager.markDirty();
            player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11796_, SoundSource.PLAYERS, 0.8f, 1.0f);
            player.m_5661_((Component)Component.m_237110_((String)"text.currencycraft.atm.withdrawal_success", (Object[])new Object[]{String.format("%.2f", (double)this.amount / 100.0)}), true);
            if (Config.withdrawalFee > 0L) {
                player.m_5661_((Component)Component.m_237110_((String)"text.currencycraft.atm.withdrawal_fee", (Object[])new Object[]{String.format("%.2f", (double)Config.withdrawalFee / 100.0)}), true);
            }
            if ((patt5561$temp = player.f_36096_) instanceof ATMMainMenu) {
                ATMMainMenu menu = (ATMMainMenu)patt5561$temp;
                menu.updateBalance();
            }
        });
        return true;
    }
}

