/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.network.packets;

import cc.spea.currencycraft.bank.BankAccountData;
import cc.spea.currencycraft.bank.BankAccountManager;
import cc.spea.currencycraft.items.DebitCardItem;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class C2SDisableDebitCard {
    public C2SDisableDebitCard() {
    }

    public C2SDisableDebitCard(FriendlyByteBuf buf) {
    }

    public void toBytes(FriendlyByteBuf buf) {
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            BankAccountManager manager = BankAccountManager.get(player.f_8924_);
            BankAccountData account = manager.getAccount(player.m_20148_());
            if (!account.hasActiveCard()) {
                player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.no_active_card"), true);
                return;
            }
            UUID activeCardId = account.getActiveCardId();
            account.disableActiveCard();
            manager.markDirty();
            boolean foundCard = false;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (!(stack.m_41720_() instanceof DebitCardItem) || !activeCardId.equals(DebitCardItem.getCardId(stack))) continue;
                DebitCardItem.setCancelled(stack, true);
                foundCard = true;
            }
            player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11937_, SoundSource.PLAYERS, 0.5f, 1.5f);
            player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.card_disabled"), true);
            player.m_6915_();
        });
        return true;
    }
}

