/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.network.packets;

import cc.spea.currencycraft.blocks.VendingMachine.VendingMachineBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class C2SPurchaseVendingMachineItem {
    private final BlockPos pos;
    private final int slotIndex;
    private final boolean buyAll;

    public C2SPurchaseVendingMachineItem(BlockPos pos, int slotIndex, boolean buyAll) {
        this.pos = pos;
        this.slotIndex = slotIndex;
        this.buyAll = buyAll;
    }

    public C2SPurchaseVendingMachineItem(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.slotIndex = buf.readInt();
        this.buyAll = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.slotIndex);
        buf.writeBoolean(this.buyAll);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            BlockEntity patt1649$temp;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            if (player.m_9236_().m_46749_(this.pos) && (patt1649$temp = player.m_9236_().m_7702_(this.pos)) instanceof VendingMachineBlockEntity) {
                VendingMachineBlockEntity be = (VendingMachineBlockEntity)patt1649$temp;
                if (this.buyAll) {
                    int purchaseCount = 0;
                    boolean keepBuying = true;
                    while (keepBuying) {
                        boolean success = be.purchaseItem(this.slotIndex);
                        if (success) {
                            ++purchaseCount;
                            continue;
                        }
                        keepBuying = false;
                        if (purchaseCount != 0) continue;
                        player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.vending_machine.out_of_order"), true);
                        player.m_9236_().m_5594_(null, this.pos, SoundEvents.f_11668_, SoundSource.BLOCKS, 0.5f, 0.8f);
                    }
                } else {
                    boolean success = be.purchaseItem(this.slotIndex);
                    if (!success) {
                        player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.vending_machine.out_of_order"), true);
                        player.m_9236_().m_5594_(null, this.pos, SoundEvents.f_11668_, SoundSource.BLOCKS, 0.5f, 0.8f);
                    }
                }
            }
        });
        return true;
    }
}

