/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.network.packets;

import cc.spea.currencycraft.bank.BankAccountData;
import cc.spea.currencycraft.bank.BankAccountManager;
import cc.spea.currencycraft.items.DebitCardItem;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class C2SSetupDebitCard {
    private final String pin;

    public C2SSetupDebitCard(String pin) {
        this.pin = pin;
    }

    public C2SSetupDebitCard(FriendlyByteBuf buf) {
        this.pin = buf.m_130277_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.pin);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            if (this.pin == null || this.pin.length() != 4 || !this.pin.matches("\\d{4}")) {
                player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.invalid_pin"), true);
                return;
            }
            ItemStack heldItem = player.m_21205_();
            if (heldItem.m_41619_() || !(heldItem.m_41720_() instanceof DebitCardItem)) {
                player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.no_card"), true);
                return;
            }
            if (!DebitCardItem.isBlankCard(heldItem)) {
                player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.card_not_blank"), true);
                return;
            }
            UUID cardId = UUID.randomUUID();
            DebitCardItem.setCardId(heldItem, cardId);
            DebitCardItem.setPin(heldItem, this.pin);
            DebitCardItem.setOwner(heldItem, player.m_20148_(), player.m_7755_().getString());
            BankAccountManager manager = BankAccountManager.get(player.f_8924_);
            BankAccountData account = manager.getAccount(player.m_20148_());
            if (account.hasActiveCard()) {
                player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.card_already_exists"), true);
                return;
            }
            account.setActiveCard(cardId, this.pin);
            manager.markDirty();
            player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12509_, SoundSource.PLAYERS, 0.7f, 1.0f);
            player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.card_setup_success"), true);
            player.m_6915_();
        });
        return true;
    }
}

