/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.currencycraft.network.packets;

import cc.spea.currencycraft.bank.BankAccountData;
import cc.spea.currencycraft.bank.BankAccountManager;
import cc.spea.currencycraft.gui.ATM.ATMMainMenu;
import cc.spea.currencycraft.items.DebitCardItem;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class C2SVerifyPinAndOpenATM {
    private final String enteredPin;

    public C2SVerifyPinAndOpenATM(String enteredPin) {
        this.enteredPin = enteredPin;
    }

    public C2SVerifyPinAndOpenATM(FriendlyByteBuf buf) {
        this.enteredPin = buf.m_130277_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.enteredPin);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            if (this.enteredPin == null || this.enteredPin.length() != 4 || !this.enteredPin.matches("\\d{4}")) {
                player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.invalid_pin"), true);
                player.m_6915_();
                return;
            }
            ItemStack cardStack = player.m_21205_();
            if (!DebitCardItem.isValidCard(cardStack)) {
                player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.invalid_card"), true);
                player.m_6915_();
                return;
            }
            UUID cardId = DebitCardItem.getCardId(cardStack);
            String storedPin = DebitCardItem.getPin(cardStack);
            UUID ownerUuid = DebitCardItem.getOwnerUuid(cardStack);
            if (ownerUuid == null) {
                ownerUuid = player.m_20148_();
            }
            if (!this.enteredPin.equals(storedPin)) {
                player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.incorrect_pin"), true);
                player.m_6915_();
                return;
            }
            BankAccountManager manager = BankAccountManager.get(player.f_8924_);
            BankAccountData account = manager.getAccount(ownerUuid);
            if (!account.isCardValid(cardId, storedPin)) {
                player.m_5661_((Component)Component.m_237115_((String)"text.currencycraft.atm.card_not_authorized"), true);
                player.m_6915_();
                return;
            }
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return Component.m_237115_((String)"container.currencycraft.atm_main");
                }

                public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
                    return new ATMMainMenu(windowId, playerInventory, (Container)new SimpleContainer(1), (ContainerData)new SimpleContainerData(4));
                }
            });
        });
        return true;
    }
}

