/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.networkLink;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.LogisticsManager;
import com.simibubi.create.content.logistics.packagerLink.RequestPromise;
import com.simibubi.create.content.logistics.packagerLink.RequestPromiseQueue;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericCapabilityWrapperProvider;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericKeyRegistration;
import ru.zznty.create_factory_abstractions.generic.impl.GenericContentExtender;
import ru.zznty.create_factory_abstractions.generic.support.BigGenericStack;
import ru.zznty.create_factory_abstractions.generic.support.GenericInventorySummary;
import ru.zznty.create_factory_logistics.logistics.networkLink.NetworkLinkBlock;
import ru.zznty.create_factory_logistics.logistics.networkLink.NetworkLinkMode;

public class NetworkLinkBlockEntity
extends SmartBlockEntity {
    private LogisticallyLinkedBehaviour link;
    @Nullable
    private GenericKeyRegistration registration;
    private ScrollOptionBehaviour<NetworkLinkMode> scroll;

    public NetworkLinkBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.link = new LogisticallyLinkedBehaviour((SmartBlockEntity)this, false);
        behaviours.add((BlockEntityBehaviour)this.link);
        this.scroll = new ScrollOptionBehaviour(NetworkLinkMode.class, (Component)Component.m_237115_((String)"create_factory_logistics.gui.network_link.mode"), (SmartBlockEntity)this, (ValueBoxTransform)new ValueBox());
        behaviours.add((BlockEntityBehaviour)this.scroll);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (tag.m_128425_("ingredient_type", 8)) {
            this.registration = (GenericKeyRegistration)((IForgeRegistry)GenericContentExtender.REGISTRY.get()).getValue(ResourceLocation.parse((String)tag.m_128461_("ingredient_type")));
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.registration != null) {
            tag.m_128359_("ingredient_type", ((IForgeRegistry)GenericContentExtender.REGISTRY.get()).getKey((Object)this.registration).toString());
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        GenericCapabilityWrapperProvider provider;
        if (this.registration != null && (side == null || NetworkLinkBlockEntity.getConnectedDirection(this.m_58900_()).m_122424_() == side) && (provider = this.registration.provider().capabilityWrapperProvider()) != null) {
            return provider.capability().orEmpty(cap, LazyOptional.of(() -> provider.wrap((scanInputSlots, summary) -> {
                RequestPromiseQueue queue;
                if (((NetworkLinkMode)this.scroll.get()).includesStored()) {
                    summary.add(GenericInventorySummary.of((InventorySummary)LogisticsManager.getSummaryOfNetwork((UUID)this.link.freqId, (boolean)true)));
                }
                if (((NetworkLinkMode)this.scroll.get()).includesPromised() && (queue = Create.LOGISTICS.getQueuedPromises(this.link.freqId)) != null) {
                    for (RequestPromise promise : queue.flatten(false)) {
                        BigGenericStack stack = BigGenericStack.of((BigItemStack)promise.promisedStack);
                        if (stack.get().isEmpty()) continue;
                        summary.add(stack.get());
                    }
                }
            })).cast());
        }
        return super.getCapability(cap, side);
    }

    public static Direction getConnectedDirection(BlockState arg) {
        switch ((AttachFace)arg.m_61143_((Property)NetworkLinkBlock.f_53179_)) {
            case CEILING: {
                return Direction.DOWN;
            }
            case FLOOR: {
                return Direction.UP;
            }
        }
        return (Direction)arg.m_61143_((Property)NetworkLinkBlock.f_54117_);
    }

    private static class ValueBox
    extends ValueBoxTransform.Sided {
        private ValueBox() {
        }

        public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
            float yRot = AngleHelper.horizontalAngle((Direction)(state.m_61143_((Property)NetworkLinkBlock.f_53179_) == AttachFace.FLOOR ? (Direction)state.m_61143_((Property)NetworkLinkBlock.f_54117_) : this.getSide().m_122424_()));
            float xRot = AngleHelper.verticalAngle((Direction)this.getSide().m_122424_());
            ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees(yRot)).rotateXDegrees(xRot);
        }

        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            Vec3 location;
            if (state.m_61143_((Property)NetworkLinkBlock.f_53179_) == AttachFace.FLOOR) {
                location = VecHelper.voxelSpace((double)8.0, (double)6.0, (double)5.0);
                location = VecHelper.rotateCentered((Vec3)location, (double)AngleHelper.horizontalAngle((Direction)((Direction)state.m_61143_((Property)NetworkLinkBlock.f_54117_))), (Direction.Axis)Direction.Axis.Y);
            } else {
                location = VecHelper.voxelSpace((double)8.0, (double)5.0, (double)6.0);
                location = VecHelper.rotateCentered((Vec3)location, (double)AngleHelper.verticalAngle((Direction)this.getSide()), (Direction.Axis)Direction.Axis.X);
            }
            location = VecHelper.rotateCentered((Vec3)location, (double)AngleHelper.horizontalAngle((Direction)this.getSide()), (Direction.Axis)Direction.Axis.Y);
            return location;
        }

        protected Vec3 getSouthLocation() {
            return null;
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            if (state.m_61143_((Property)NetworkLinkBlock.f_53179_) == AttachFace.FLOOR) {
                return direction == Direction.UP;
            }
            return state.m_61143_((Property)NetworkLinkBlock.f_54117_) == direction;
        }
    }
}

